/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.datasets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElasticSearchResponse {
    private static final Log log = LogFactory.getLog(ElasticSearchResponse.class);
    private long total;
    private List<String> xmlRecords;

    public static ElasticSearchResponse createNewResponse(String response) {
        ElasticSearchResponse item = new ElasticSearchResponse();
        if (response == null) {
            log.fatal((Object)"Error: null elasticsearch reponse");
            return null;
        }
        JsonElement jElement = new JsonParser().parse(response);
        JsonObject jobject = jElement.getAsJsonObject();
        if (jobject.has("hits")) {
            item.setTotal(jobject.get("hits").getAsJsonObject().get("total").getAsLong());
            JsonElement hits = ((JsonObject)jobject.get("hits")).get("hits");
            JsonArray hitsObject = hits.getAsJsonArray();
            ArrayList<String> records = new ArrayList<String>();
            for (JsonElement elem : hitsObject) {
                JsonObject _source = (JsonObject)((JsonObject)elem).get("_source");
                String xml = _source.get("xml").getAsString();
                records.add(xml);
            }
            item.setXmlRecords(records);
            return item;
        }
        return null;
    }

    public List<String> getXmlRecords() {
        return this.xmlRecords;
    }

    public void setXmlRecords(List<String> xmlRecords) {
        this.xmlRecords = xmlRecords;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }
}

