/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.datacite;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.data.collector.plugins.datacite.schema.DataciteSchema;
import eu.dnetlib.data.collector.plugins.datacite.schema.Result;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class DataciteESIterator
implements Iterator<String> {
    private final long timestamp;
    private String scrollId;
    private Queue<String> currentPage;
    private final Gson g = new GsonBuilder().create();
    private String baseURL;
    private static final String START_PATH = "new_scan";
    private static final String NEXT_PATH = "scan/%s";

    public DataciteESIterator(long timestamp, String baseUrl) throws Exception {
        this.timestamp = timestamp;
        this.baseURL = baseUrl;
        this.currentPage = new ArrayDeque<String>();
        this.startRequest();
    }

    private static String decompression(Result r) {
        try {
            byte[] byteArray = Base64.decodeBase64((byte[])r.getBody().getBytes());
            Inflater decompresser = new Inflater();
            decompresser.setInput(byteArray);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(byteArray.length);
            byte[] buffer = new byte[8192];
            while (!decompresser.finished()) {
                int size = decompresser.inflate(buffer);
                bos.write(buffer, 0, size);
            }
            byte[] unzippeddata = bos.toByteArray();
            decompresser.end();
            return new String(unzippeddata);
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    private void fillQueue(String hits) {
        if (StringUtils.isBlank((CharSequence)hits) || "[]".equalsIgnoreCase(hits.trim())) {
            return;
        }
        try {
            DataciteSchema datacitepage = (DataciteSchema)this.g.fromJson(hits, DataciteSchema.class);
            this.scrollId = datacitepage.getScrollId();
            datacitepage.getResult().stream().map(DataciteESIterator::decompression).filter(Objects::nonNull).forEach(this.currentPage::add);
        }
        catch (Throwable e) {
            System.out.println(hits);
            e.printStackTrace();
        }
    }

    private void startRequest() throws Exception {
        String url = this.baseURL + "/" + START_PATH;
        URL startUrl = new URL(this.timestamp > 0L ? url + "?timestamp=" + this.timestamp : url);
        this.fillQueue(IOUtils.toString((InputStream)startUrl.openStream()));
    }

    private void getNextPage() throws IOException {
        String url = this.baseURL + "/" + NEXT_PATH;
        URL startUrl = new URL(String.format(url, this.scrollId));
        this.fillQueue(IOUtils.toString((InputStream)startUrl.openStream()));
    }

    @Override
    public boolean hasNext() {
        return this.currentPage.size() > 0;
    }

    @Override
    public String next() {
        if (this.currentPage.size() == 0) {
            return null;
        }
        String nextItem = this.currentPage.remove();
        if (this.currentPage.size() == 0) {
            try {
                this.getNextPage();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return nextItem;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }
}

