/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.rest;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class RestIterator
implements Iterator<String> {
    private static final String wrapName = "recordWrap";
    private String baseUrl;
    private String resumptionType;
    private String resumptionParam;
    private String resultFormatValue;
    private String queryParams;
    private int resultSizeValue = 100;
    private Queue<String> queue;
    private int resumptionInt = 0;
    private int resultTotal = -1;
    private String resumptionStr = Integer.toString(this.resumptionInt);
    private InputStream resultStream;
    private Transformer transformer;
    private XPath xpath;
    private XPathExpression xprResultTotalPath;
    private XPathExpression xprResumptionPath;
    private String queryFormat;
    private String querySize;

    public RestIterator(String baseUrl, String resumptionType, String resumptionParam, String resumptionXpath, String resultTotalXpath, String resultFormatParam, String resultFormatValue, String resultSizeParam, int resultSizeValue, String queryParams) {
        this.baseUrl = baseUrl;
        this.resumptionType = resumptionType;
        this.resumptionParam = resumptionParam;
        this.resultFormatValue = resultFormatValue;
        this.resultSizeValue = resultSizeValue;
        this.queryParams = queryParams;
        this.queryFormat = resultFormatParam != "" ? "&" + resultFormatParam + "=" + resultFormatValue : "";
        this.querySize = resultSizeParam != "" ? "&" + resultSizeParam + "=" + resultSizeValue : "";
        try {
            this.initXmlTransformation(resultTotalXpath, resumptionXpath);
        }
        catch (Exception exp) {
            throw new IllegalStateException("xml transformation init failed: " + exp.getMessage());
        }
        this.initQueue();
        this.updateQueue();
    }

    private void initXmlTransformation(String resultTotalXpath, String resumptionXpath) throws TransformerConfigurationException, XPathExpressionException {
        String resumpXpath = resumptionXpath == "" ? "/" : resumptionXpath;
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xprResultTotalPath = this.xpath.compile(resultTotalXpath);
        this.xprResumptionPath = this.xpath.compile(resumpXpath);
    }

    private void initQueue() {
        this.queue = new LinkedList<String>();
    }

    private void disconnect() {
    }

    private void updateQueue() {
        String query = this.baseUrl + "?" + this.queryParams + this.querySize + "&" + this.resumptionParam + "=" + this.resumptionStr + this.queryFormat;
        System.out.println("query: " + query);
        this.queue.add(query);
    }

    @Override
    public boolean hasNext() {
        if (this.queue.isEmpty()) {
            this.disconnect();
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        String nextQuery = this.queue.remove();
        String resultXml = "";
        try {
            this.resultStream = new URL(nextQuery).openStream();
            if (this.resultFormatValue == "json") {
                String resultJson = IOUtils.toString((InputStream)this.resultStream, (String)"UTF-8");
                while (resultJson.matches(".*\"([^\"]*)\\s+([^\"]*)\":.*")) {
                    resultJson = resultJson.replaceAll("\"([^\"]*)\\s+([^\"]*)\":", "\"$1_$2\":");
                }
                JSONObject jsonObject = new JSONObject(resultJson);
                resultXml = XML.toString((Object)jsonObject, (String)wrapName);
                this.resultStream = IOUtils.toInputStream((String)resultXml, (String)"UTF-8");
            }
            InputSource inSource = new InputSource(this.resultStream);
            Node resultNode = (Node)this.xpath.evaluate("/", inSource, XPathConstants.NODE);
            this.resumptionInt += this.resultSizeValue;
            if (this.resumptionType == "scan") {
                this.resumptionStr = this.xprResumptionPath.evaluate(resultNode);
            }
            if (this.resumptionType == "count") {
                this.resumptionStr = Integer.toString(this.resumptionInt);
            }
            if (this.resultTotal == -1) {
                this.resultTotal = Integer.parseInt(this.xprResultTotalPath.evaluate(resultNode));
                System.out.println("resultTotal: " + this.resultTotal);
            }
            System.out.println("resultTotal: " + this.resultTotal);
            System.out.println("resInt: " + this.resumptionInt);
            if (this.resumptionInt < this.resultTotal) {
                this.updateQueue();
            }
            return resultXml;
        }
        catch (Exception exc) {
            exc.printStackTrace(System.err);
            throw new IllegalStateException("collection failed: " + exc.getMessage());
        }
    }
}

