/**
 * 
 */
package eu.dnetlib.data.collector.plugins.rest;

import java.util.Iterator;

import org.apache.commons.lang3.StringUtils;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

/**
 * @author js
 *
 */
public class RestCollectorPlugin extends AbstractCollectorPlugin {

	@Override
	public Iterable<String> collect(InterfaceDescriptor ifDescriptor, String arg1, String arg2)
			throws CollectorServiceException {
		final String baseUrl = ifDescriptor.getBaseUrl();
		final String resumptionType = ifDescriptor.getParams().get("resumptionType");
		final String resumptionParam = ifDescriptor.getParams().get("resumptionParam");
		final String resumptionXpath = ifDescriptor.getParams().get("resumptionXpath");
		final String resultTotalXpath = ifDescriptor.getParams().get("resultTotalXpath");
		final String resultFormatParam = ifDescriptor.getParams().get("resultFormatParam");
		final String resultFormatValue = ifDescriptor.getParams().get("resultFormatValue");
		final String resultSizeParam = ifDescriptor.getParams().get("resultSizeParam");
		final String queryParams = ifDescriptor.getParams().get("queryParams");
		
		if (StringUtils.isBlank(baseUrl)) {throw new CollectorServiceException("Param 'baseUrl' is null or empty");}
		if (StringUtils.isBlank(resumptionType)) {throw new CollectorServiceException("Param 'resumptionType' is null or empty");}
		if (StringUtils.isBlank(resumptionParam)) {throw new CollectorServiceException("Param 'resumptionParam' is null or empty");}
		// if (StringUtils.isBlank(resumptionXpath)) {throw new CollectorServiceException("Param 'resumptionXpath' is null or empty");}
		// if (StringUtils.isBlank(resultTotalXpath)) {throw new CollectorServiceException("Param 'resultTotalXpath' is null or empty");}
		if (StringUtils.isBlank(resultFormatParam)) {throw new CollectorServiceException("Param 'resultFormatParam' is null or empty");}
		if (StringUtils.isBlank(resultFormatValue)) {throw new CollectorServiceException("Param 'resultFormatValue' is null or empty");}
		if (StringUtils.isBlank(resultSizeParam)) {throw new CollectorServiceException("Param 'resultSizeParam' is null or empty");}
		if (StringUtils.isBlank(queryParams)) {throw new CollectorServiceException("Param 'queryParams' is null or empty");}
		
		return new Iterable<String>() {
			
			@Override
			public Iterator<String> iterator() {
				return new RestIterator(baseUrl, resumptionType, resumptionParam, resumptionXpath, resultTotalXpath, resultFormatParam, resultFormatValue, resultSizeParam, queryParams);
			}
		};
	}

}
