/**
 * 
 */
package eu.dnetlib.data.collector.plugins.rest;

import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import eu.dnetlib.data.collector.plugins.oai.OaiIterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;

/**
 * @author Jochen Schirrwagen, Aenne Loehden
 *
 */
public class RestIterator implements Iterator<String> {

	private static final Log log = LogFactory.getLog(OaiIterator.class); // NOPMD by marko on 11/24/08 5:02 PM

	private static final String wrapName = "recordWrap";
	private String baseUrl;
	private String resumptionType;
	private String resumptionParam;
	private String resultFormatValue;
	private String queryParams;
	private int resultSizeValue = 100;
	private int resumptionInt = 0;			// integer resumption token (first record to harvest)
	private int resultTotal = -1;
	private String resumptionStr = Integer.toString(resumptionInt);  // string resumption token (first record to harvest or token scanned from results)
	private InputStream resultStream;
	private Transformer transformer;
	private XPath xpath;
	private String query;
	private XPathExpression xprResultTotalPath;
	private XPathExpression xprResumptionPath;
	private XPathExpression xprEntity;
	private String queryFormat;
	private String querySize;
	private Queue<String> recordQueue = new PriorityBlockingQueue<String>();
	
	/*
	 * 
	 */
	public RestIterator(
			final String baseUrl,
			final String resumptionType,
			final String resumptionParam,
			final String resumptionXpath,
			final String resultTotalXpath,
			final String resultFormatParam,
			final String resultFormatValue,
			final String resultSizeParam,
			final String queryParams,
			final String entityXpath
			) {
		this.baseUrl = baseUrl;
		this.resumptionType = resumptionType;
		this.resumptionParam = resumptionParam;
		this.resultFormatValue = resultFormatValue;
		this.queryParams = queryParams;
		
        queryFormat = (resultFormatParam!="")? "&" + resultFormatParam + "=" + resultFormatValue : "";
        querySize = (resultSizeParam!="")? "&" + resultSizeParam + "=" + resultSizeValue : "";

		try {
			initXmlTransformation(resultTotalXpath, resumptionXpath, entityXpath);
		}catch(Exception exp) {
			throw new IllegalStateException("xml transformation init failed: " + exp.getMessage());
		}
        initQueue();
	}
	
	private void initXmlTransformation(String resultTotalXpath, String resumptionXpath, String entityXpath) throws TransformerConfigurationException, XPathExpressionException{
		String resumpXpath = (resumptionXpath=="") ? "/" : resumptionXpath;

		transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty(OutputKeys.INDENT,"yes"); 
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount","3");
		xpath = XPathFactory.newInstance().newXPath();
		xprResultTotalPath = xpath.compile(resultTotalXpath);
		xprResumptionPath = xpath.compile(resumpXpath);
		xprEntity = xpath.compile(entityXpath);
	}
	
	private void initQueue() {
		query = baseUrl + "?" + queryParams + querySize + "&" + resumptionParam + "=" + resumptionStr + queryFormat;
	}
	
	private void disconnect() {
		// TODO close inputstream
	}
	
	/* (non-Javadoc)
	 * @see java.util.Iterator#hasNext()
	 */
	@Override
	public boolean hasNext() {
		if (recordQueue.isEmpty() && query.isEmpty()) {
			disconnect();
			return false;
		} else {
			return true;
		}
	}

	/* (non-Javadoc)
	 * @see java.util.Iterator#next()
	 */
	@Override
	public String next() {
		// TODO Auto-generated method stub
		
		synchronized (recordQueue) {
			while (recordQueue.isEmpty() && !query.isEmpty() ) {
				try {
					query = downloadPage(query);
				}catch(CollectorServiceException e) {
					throw new RuntimeException(e);
				}
			}
			return recordQueue.poll();
		}
	}
	
	
	/*
	 * download page and return nextQuery
	 */
	private String downloadPage(String query) throws CollectorServiceException{
		String resultJson;
		String resultXml = "";
		String nextQuery = "";
		try {
            resultStream = new URL(query).openStream();
			if(resultFormatValue == "json"){				
				resultJson = IOUtils.toString(resultStream,"UTF-8");
				// pre-clean json - rid spaces of element names (misinterpreted as elements with attributes in xml)
				while(resultJson.matches(".*\"([^\"]*)\\s+([^\"]*)\":.*")){
					resultJson = resultJson.replaceAll("\"([^\"]*)\\s+([^\"]*)\":", "\"$1_$2\":");
				}
				org.json.JSONObject jsonObject = new org.json.JSONObject(resultJson);
				resultXml = org.json.XML.toString(jsonObject,wrapName); // wrap xml in single root element
//				System.out.println(resultXml);
				resultStream = IOUtils.toInputStream(resultXml,"UTF-8");
			}
			
			InputSource inSource = new InputSource(resultStream);

			Node resultNode = (Node) xpath.evaluate("/", inSource, XPathConstants.NODE);

			NodeList nodeList = (NodeList) xprEntity.evaluate(resultNode, XPathConstants.NODESET);
			
			for (int i = 0; i < nodeList.getLength(); i++) {
				Node n = nodeList.item(i);
				StringWriter sw = new StringWriter();
				transformer.transform(new DOMSource(n), new StreamResult(sw));
				recordQueue.add(sw.toString());
			}
				
			resumptionInt += resultSizeValue;
			if(resumptionType=="scan"){ resumptionStr = xprResumptionPath.evaluate(resultNode);}
			if(resumptionType=="count"){ resumptionStr = Integer.toString(resumptionInt); }

			if (resultTotal == -1) {
				resultTotal = Integer.parseInt(xprResultTotalPath.evaluate(resultNode));
				System.out.println("resultTotal: " + resultTotal);
			}
			System.out.println("resultTotal: " + resultTotal);
			System.out.println("resInt: " + resumptionInt);
			if (resumptionInt < resultTotal) {
				nextQuery = baseUrl + "?" + queryParams + querySize + "&" + resumptionParam + "=" + resumptionStr + queryFormat;
			}else
				nextQuery = "";
			return nextQuery;

		}catch(Exception exc) {
			exc.printStackTrace(System.err);
			throw new IllegalStateException("collection failed: " + exc.getMessage());
		}

	}

}
