/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.datasources;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.plugins.HttpConnector;
import eu.dnetlib.data.collector.plugins.datasources.Re3DataRepositoriesIterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class Re3DataCollectorPlugin
extends AbstractCollectorPlugin {
    private String repositoryListPath = "/api/v1/repositories";
    @Autowired
    private HttpConnector httpConnector;

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String repositoryListURL = interfaceDescriptor.getBaseUrl() + this.repositoryListPath;
        try {
            String input = this.httpConnector.getInputSource(repositoryListURL);
            return new Re3DataRepositoriesIterator(IOUtils.toInputStream((String)input, (String)"UTF-8"), interfaceDescriptor.getBaseUrl(), this.getHttpConnector());
        }
        catch (IOException e) {
            throw new CollectorServiceException((Throwable)e);
        }
    }

    public String getRepositoryListPath() {
        return this.repositoryListPath;
    }

    public void setRepositoryListPath(String repositoryListPath) {
        this.repositoryListPath = repositoryListPath;
    }

    public HttpConnector getHttpConnector() {
        return this.httpConnector;
    }

    public void setHttpConnector(HttpConnector httpConnector) {
        this.httpConnector = httpConnector;
    }
}

