/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.rest;

import eu.dnetlib.data.collector.plugins.oai.OaiIterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(OaiIterator.class);
    private static final String wrapName = "recordWrap";
    private String baseUrl;
    private String resumptionType;
    private String resumptionParam;
    private String resultFormatValue;
    private String queryParams;
    private int resultSizeValue = 100;
    private int resumptionInt = 0;
    private int resultTotal = -1;
    private String resumptionStr = Integer.toString(this.resumptionInt);
    private InputStream resultStream;
    private Transformer transformer;
    private XPath xpath;
    private String query;
    private XPathExpression xprResultTotalPath;
    private XPathExpression xprResumptionPath;
    private XPathExpression xprEntity;
    private String queryFormat;
    private String querySize;
    private Queue<String> recordQueue = new PriorityBlockingQueue<String>();

    public RestIterator(String baseUrl, String resumptionType, String resumptionParam, String resumptionXpath, String resultTotalXpath, String resultFormatParam, String resultFormatValue, String resultSizeParam, String queryParams, String entityXpath) {
        this.baseUrl = baseUrl;
        this.resumptionType = resumptionType;
        this.resumptionParam = resumptionParam;
        this.resultFormatValue = resultFormatValue;
        this.queryParams = queryParams;
        this.queryFormat = resultFormatParam != "" ? "&" + resultFormatParam + "=" + resultFormatValue : "";
        this.querySize = resultSizeParam != "" ? "&" + resultSizeParam + "=" + this.resultSizeValue : "";
        try {
            this.initXmlTransformation(resultTotalXpath, resumptionXpath, entityXpath);
        }
        catch (Exception exp) {
            throw new IllegalStateException("xml transformation init failed: " + exp.getMessage());
        }
        this.initQueue();
    }

    private void initXmlTransformation(String resultTotalXpath, String resumptionXpath, String entityXpath) throws TransformerConfigurationException, XPathExpressionException {
        String resumpXpath = resumptionXpath == "" ? "/" : resumptionXpath;
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xprResultTotalPath = this.xpath.compile(resultTotalXpath);
        this.xprResumptionPath = this.xpath.compile(resumpXpath);
        this.xprEntity = this.xpath.compile(entityXpath);
    }

    private void initQueue() {
        this.query = this.baseUrl + "?" + this.queryParams + this.querySize + "&" + this.resumptionParam + "=" + this.resumptionStr + this.queryFormat;
    }

    private void disconnect() {
    }

    @Override
    public boolean hasNext() {
        if (this.recordQueue.isEmpty() && this.query.isEmpty()) {
            this.disconnect();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.recordQueue;
        synchronized (queue) {
            while (this.recordQueue.isEmpty() && !this.query.isEmpty()) {
                try {
                    this.query = this.downloadPage(this.query);
                }
                catch (CollectorServiceException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.recordQueue.poll();
        }
    }

    private String downloadPage(String query) throws CollectorServiceException {
        String resultXml = "";
        String nextQuery = "";
        try {
            this.resultStream = new URL(query).openStream();
            if (this.resultFormatValue == "json") {
                String resultJson = IOUtils.toString((InputStream)this.resultStream, (String)"UTF-8");
                while (resultJson.matches(".*\"([^\"]*)\\s+([^\"]*)\":.*")) {
                    resultJson = resultJson.replaceAll("\"([^\"]*)\\s+([^\"]*)\":", "\"$1_$2\":");
                }
                JSONObject jsonObject = new JSONObject(resultJson);
                resultXml = XML.toString((Object)jsonObject, (String)wrapName);
                this.resultStream = IOUtils.toInputStream((String)resultXml, (String)"UTF-8");
            }
            InputSource inSource = new InputSource(this.resultStream);
            Node resultNode = (Node)this.xpath.evaluate("/", inSource, XPathConstants.NODE);
            NodeList nodeList = (NodeList)this.xprEntity.evaluate(resultNode, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                StringWriter sw = new StringWriter();
                this.transformer.transform(new DOMSource(n), new StreamResult(sw));
                this.recordQueue.add(sw.toString());
            }
            this.resumptionInt += this.resultSizeValue;
            if (this.resumptionType == "scan") {
                this.resumptionStr = this.xprResumptionPath.evaluate(resultNode);
            }
            if (this.resumptionType == "count") {
                this.resumptionStr = Integer.toString(this.resumptionInt);
            }
            if (this.resultTotal == -1) {
                this.resultTotal = Integer.parseInt(this.xprResultTotalPath.evaluate(resultNode));
                System.out.println("resultTotal: " + this.resultTotal);
            }
            System.out.println("resultTotal: " + this.resultTotal);
            System.out.println("resInt: " + this.resumptionInt);
            nextQuery = this.resumptionInt < this.resultTotal ? this.baseUrl + "?" + this.queryParams + this.querySize + "&" + this.resumptionParam + "=" + this.resumptionStr + this.queryFormat : "";
            return nextQuery;
        }
        catch (Exception exc) {
            exc.printStackTrace(System.err);
            throw new IllegalStateException("collection failed: " + exc.getMessage());
        }
    }
}

