/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.rest;

import eu.dnetlib.data.collector.plugins.utils.JsonUtils;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RestIterator
implements Iterator<String> {
    private final String AUTHBASIC = "basic";
    private static final Log log = LogFactory.getLog(RestIterator.class);
    private JsonUtils jsonUtils;
    private String baseUrl;
    private String resumptionType;
    private String resumptionParam;
    private String resultFormatValue;
    private String queryParams = "";
    private int resultSizeValue;
    private int resumptionInt = 0;
    private int resultTotal = -1;
    private String resumptionStr = Integer.toString(this.resumptionInt);
    private InputStream resultStream;
    private Transformer transformer;
    private XPath xpath;
    private String query;
    private XPathExpression xprResultTotalPath;
    private XPathExpression xprResumptionPath;
    private XPathExpression xprEntity;
    private String queryFormat;
    private String querySize;
    private String authMethod;
    private String authToken;
    private Queue<String> recordQueue = new PriorityBlockingQueue<String>();
    private int discoverResultSize = 0;
    private int pagination = 1;
    private String resultOutputFormat;

    public RestIterator(String baseUrl, String resumptionType, String resumptionParam, String resumptionXpath, String resultTotalXpath, String resultFormatParam, String resultFormatValue, String resultSizeParam, String resultSizeValueStr, String queryParams, String entityXpath, String authMethod, String authToken, String resultOutputFormat) {
        this.jsonUtils = new JsonUtils();
        this.baseUrl = baseUrl;
        this.resumptionType = resumptionType;
        this.resumptionParam = resumptionParam;
        this.resultFormatValue = resultFormatValue;
        this.queryParams = queryParams;
        this.resultSizeValue = Integer.valueOf(resultSizeValueStr);
        this.authMethod = authMethod;
        this.authToken = authToken;
        this.resultOutputFormat = resultOutputFormat;
        this.queryFormat = StringUtils.isNotBlank((CharSequence)resultFormatParam) ? "&" + resultFormatParam + "=" + resultFormatValue : "";
        this.querySize = StringUtils.isNotBlank((CharSequence)resultSizeParam) ? "&" + resultSizeParam + "=" + resultSizeValueStr : "";
        try {
            this.initXmlTransformation(resultTotalXpath, resumptionXpath, entityXpath);
        }
        catch (Exception e) {
            throw new IllegalStateException("xml transformation init failed: " + e.getMessage());
        }
        this.initQueue();
    }

    private void initXmlTransformation(String resultTotalXpath, String resumptionXpath, String entityXpath) throws TransformerConfigurationException, XPathExpressionException {
        this.transformer = TransformerFactory.newInstance().newTransformer();
        this.transformer.setOutputProperty("indent", "yes");
        this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        this.xpath = XPathFactory.newInstance().newXPath();
        this.xprResultTotalPath = this.xpath.compile(resultTotalXpath);
        this.xprResumptionPath = this.xpath.compile(StringUtils.isBlank((CharSequence)resumptionXpath) ? "/" : resumptionXpath);
        this.xprEntity = this.xpath.compile(entityXpath);
    }

    private void initQueue() {
        this.query = this.queryParams.equals("") && this.querySize.equals("") && this.queryFormat.equals("") ? this.baseUrl : this.baseUrl + "?" + this.queryParams + this.querySize + this.queryFormat;
        log.info((Object)("REST calls starting with " + this.query));
    }

    private void disconnect() {
    }

    @Override
    public boolean hasNext() {
        if (this.recordQueue.isEmpty() && this.query.isEmpty()) {
            this.disconnect();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.recordQueue;
        synchronized (queue) {
            while (this.recordQueue.isEmpty() && !this.query.isEmpty()) {
                try {
                    log.debug((Object)("get Query: " + this.query));
                    this.query = this.downloadPage(this.query);
                    log.debug((Object)("next queryURL from downloadPage(): " + this.query));
                }
                catch (CollectorServiceException e) {
                    log.debug((Object)("CollectorPlugin.next()-Exception: " + (Object)((Object)e)));
                    throw new RuntimeException(e);
                }
            }
            return this.recordQueue.poll();
        }
    }

    private String downloadPage(String query) throws CollectorServiceException {
        String resultXml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        String nextQuery = "";
        String emptyXml = resultXml + "<" + "recordWrap" + "></" + "recordWrap" + ">";
        Node resultNode = null;
        NodeList nodeList = null;
        String qUrlArgument = "";
        int urlOldResumptionSize = 0;
        if (this.resumptionType.equalsIgnoreCase("deep-cursor")) {
            log.debug((Object)("check resumptionType deep-cursor and check cursor=*?" + query));
            if (!query.contains("&cursor=")) {
                query = query + "&cursor=*";
            }
        }
        try {
            InputStream theHttpInputStream;
            HttpURLConnection conn;
            URL qUrl = new URL(query);
            log.debug((Object)("authMethod :" + this.authMethod));
            if (this.authMethod == "bearer") {
                log.trace((Object)("authMethod before inputStream: " + resultXml));
                conn = (HttpURLConnection)qUrl.openConnection();
                conn.setRequestProperty("Authorization", "Bearer " + this.authToken);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestMethod("GET");
                theHttpInputStream = conn.getInputStream();
            } else if ("basic".equalsIgnoreCase(this.authMethod)) {
                log.trace((Object)("authMethod before inputStream: " + resultXml));
                conn = (HttpURLConnection)qUrl.openConnection();
                conn.setRequestProperty("Authorization", "Basic " + this.authToken);
                conn.setRequestProperty("accept", "application/xml");
                conn.setRequestMethod("GET");
                theHttpInputStream = conn.getInputStream();
            } else {
                theHttpInputStream = qUrl.openStream();
            }
            this.resultStream = theHttpInputStream;
            if ("json".equals(this.resultOutputFormat)) {
                String resultJson = IOUtils.toString((InputStream)this.resultStream, (String)"UTF-8");
                resultXml = this.jsonUtils.convertToXML(resultJson);
                this.resultStream = IOUtils.toInputStream((String)resultXml, (String)"UTF-8");
            }
            if (!emptyXml.toLowerCase().equals(resultXml.toLowerCase())) {
                resultNode = (Node)this.xpath.evaluate("/", new InputSource(this.resultStream), XPathConstants.NODE);
                nodeList = (NodeList)this.xprEntity.evaluate(resultNode, XPathConstants.NODESET);
                log.debug((Object)("nodeList.length: " + nodeList.getLength()));
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    StringWriter sw = new StringWriter();
                    this.transformer.transform(new DOMSource(nodeList.item(i)), new StreamResult(sw));
                    String toEnqueue = sw.toString();
                    if (toEnqueue == null || StringUtils.isBlank((CharSequence)toEnqueue) || emptyXml.equalsIgnoreCase(toEnqueue)) {
                        log.warn((Object)("The following record resulted in empty item for the feeding queue: " + resultXml));
                        continue;
                    }
                    this.recordQueue.add(sw.toString());
                }
            } else {
                log.warn((Object)"resultXml is equal with emptyXml");
            }
            this.resumptionInt += this.resultSizeValue;
            switch (this.resumptionType.toLowerCase()) {
                case "scan": {
                    this.resumptionStr = this.xprResumptionPath.evaluate(resultNode);
                    break;
                }
                case "count": {
                    this.resumptionStr = Integer.toString(this.resumptionInt);
                    break;
                }
                case "discover": {
                    String[] arrayQUrlArgument;
                    if (this.resultSizeValue < 2) {
                        throw new CollectorServiceException("Mode: discover, Param 'resultSizeValue' is less than 2");
                    }
                    qUrlArgument = qUrl.getQuery();
                    for (String arrayUrlArgStr : arrayQUrlArgument = qUrlArgument.split("&")) {
                        if (!arrayUrlArgStr.startsWith(this.resumptionParam)) continue;
                        String[] resumptionKeyValue = arrayUrlArgStr.split("=");
                        if (this.isInteger(resumptionKeyValue[1])) {
                            urlOldResumptionSize = Integer.parseInt(resumptionKeyValue[1]);
                            log.debug((Object)("discover OldResumptionSize from Url (int): " + urlOldResumptionSize));
                            continue;
                        }
                        log.debug((Object)("discover OldResumptionSize from Url (str): " + resumptionKeyValue[1]));
                    }
                    if (emptyXml.toLowerCase().equals(resultXml.toLowerCase()) || nodeList != null && nodeList.getLength() < this.resultSizeValue) {
                        if (nodeList != null) {
                            this.discoverResultSize += nodeList.getLength();
                        }
                        this.resultTotal = this.discoverResultSize;
                    } else {
                        this.resumptionStr = Integer.toString(this.resumptionInt);
                        this.resultTotal = this.resumptionInt + 1;
                        if (nodeList != null) {
                            this.discoverResultSize += nodeList.getLength();
                        }
                    }
                    log.debug((Object)("discoverResultSize:  " + this.discoverResultSize));
                    break;
                }
                case "pagination": 
                case "page": {
                    ++this.pagination;
                    if (nodeList != null) {
                        this.discoverResultSize += nodeList.getLength();
                    } else {
                        this.resultTotal = this.discoverResultSize;
                        this.pagination = this.discoverResultSize;
                    }
                    this.resumptionInt = this.pagination;
                    this.resumptionStr = Integer.toString(this.resumptionInt);
                    break;
                }
                case "deep-cursor": {
                    this.resumptionStr = this.encodeValue(this.xprResumptionPath.evaluate(resultNode));
                    this.queryParams = this.queryParams.replace("&cursor=*", "");
                    this.resumptionInt = nodeList != null && nodeList.getLength() < this.discoverResultSize ? (this.resumptionInt += nodeList.getLength() + 1 - this.resultSizeValue) : (this.resumptionInt += nodeList.getLength() - this.resultSizeValue);
                    this.discoverResultSize = nodeList.getLength();
                    log.debug((Object)("downloadPage().deep-cursor: resumptionStr=" + this.resumptionStr + " ; queryParams=" + this.queryParams + " resumptionLengthIncreased: " + this.resumptionInt));
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IllegalStateException("collection failed: " + e.getMessage());
        }
        try {
            if (this.resultTotal == -1) {
                this.resultTotal = Integer.parseInt(this.xprResultTotalPath.evaluate(resultNode));
                if (this.resumptionType.toLowerCase().equals("page") && !"basic".equalsIgnoreCase(this.authMethod)) {
                    ++this.resultTotal;
                }
                log.info((Object)("resultTotal was -1 is now: " + this.resultTotal));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IllegalStateException("downloadPage() resultTotal couldn't parse: " + e.getMessage());
        }
        log.debug((Object)("resultTotal: " + this.resultTotal));
        log.debug((Object)("resInt: " + this.resumptionInt));
        nextQuery = this.resumptionInt <= this.resultTotal ? this.baseUrl + "?" + this.queryParams + this.querySize + "&" + this.resumptionParam + "=" + this.resumptionStr + this.queryFormat : "";
        log.debug((Object)("downloadPage() nextQueryUrl: " + nextQuery));
        return nextQuery;
    }

    private boolean isInteger(String s) {
        boolean isValidInteger = false;
        try {
            Integer.parseInt(s);
            isValidInteger = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return isValidInteger;
    }

    private String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    public String getResultFormatValue() {
        return this.resultFormatValue;
    }

    public String getResultOutputFormat() {
        return this.resultOutputFormat;
    }
}

