package eu.dnetlib.data.collector.plugins.eosc;

import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class EoscServicesPlugin extends AbstractCollectorPlugin {

	// Suggested values:
	// baseUrl = https://api.eosc-portal.eu
	// maxProviders = 10000
	// XPATH_ID = /record/organization/id

	@SuppressWarnings("unchecked")
	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
		throws CollectorServiceException {

		final String baseUrl = interfaceDescriptor.getBaseUrl();
		final long maxProviders = NumberUtils.toLong(interfaceDescriptor.getParams().get("maxProviders"), 10000);

		return () -> httpCall(baseUrl + "/provider/all?quantity=" + maxProviders)
			.selectNodes("/Paging/results/results")
			.stream()
			.map(o -> processProvider(baseUrl, (Node) o))
			.iterator();
	}

	private String processProvider(final String baseUrl, final Node nodeProv) {
		final String orgId = nodeProv.valueOf("./id");

		final Document newDoc = DocumentHelper.createDocument();
		final Element newRoot = DocumentHelper.createElement("record");

		newDoc.setRootElement(newRoot);

		nodeProv.setName("organization");
		newRoot.add(nodeProv.detach());

		final Document docSrvs = httpCall(baseUrl + "/provider/services/" + orgId);
		for (final Object o : docSrvs.selectNodes("/List/item")) {
			final Node nodeSrv = (Node) o;
			nodeSrv.setName("service");
			newRoot.add(nodeSrv.detach());
		}

		return newDoc.asXML();
	}

	private Document httpCall(final String url) {
		final SAXReader reader = new SAXReader();

		final HttpGet req = new HttpGet(url);
		req.addHeader("Accept", "application/xml");

		try (final CloseableHttpClient client = HttpClients.createDefault()) {
			try (final CloseableHttpResponse response = client.execute(req)) {
				return reader.read(response.getEntity().getContent());
			}
		} catch (final Exception e) {
			throw new RuntimeException(e);
		}
	}

}
