/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.projects.gtr2;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.collector.plugins.HttpConnector;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Gtr2Helper {
    private static final Log log = LogFactory.getLog(Gtr2Helper.class);
    private VTDNav mainVTDNav;
    private AutoPilot mainAutoPilot;
    private StringWriter writer;
    private HttpConnector connector;

    public String processProject(VTDNav vn, String namespaces) throws Exception {
        Thread t;
        this.writer = new StringWriter();
        this.mainVTDNav = vn;
        this.mainAutoPilot = new AutoPilot(this.mainVTDNav);
        this.writer.write("<doc " + namespaces + ">");
        this.writeFragment(this.mainVTDNav);
        this.mainAutoPilot.selectXPath("//link[@rel='FUND']");
        ExecutorService es = Executors.newFixedThreadPool(5);
        while (this.mainAutoPilot.evalXPath() != -1) {
            t = new Thread(new ProcessFunder(this.mainVTDNav.toNormalizedString(this.mainVTDNav.getAttrVal("href"))));
            es.execute(t);
        }
        this.mainAutoPilot.resetXPath();
        this.mainAutoPilot.selectXPath(".//link[@rel='LEAD_ORG']");
        while (this.mainAutoPilot.evalXPath() != -1) {
            t = new Thread(new Org(this.mainVTDNav.toNormalizedString(this.mainVTDNav.getAttrVal("href")), new String[]{"<ld-org>", "</ld-org>"}));
            es.execute(t);
        }
        this.mainAutoPilot.resetXPath();
        this.mainAutoPilot.selectXPath(".//link[@rel='PP_ORG']");
        while (this.mainAutoPilot.evalXPath() != -1) {
            t = new Thread(new Org(this.mainVTDNav.toNormalizedString(this.mainVTDNav.getAttrVal("href")), new String[]{"<pp-org>", "</pp-org>"}));
            es.execute(t);
        }
        this.mainAutoPilot.resetXPath();
        this.mainAutoPilot.selectXPath(".//link[@rel='PI_PER']");
        while (this.mainAutoPilot.evalXPath() != -1) {
            t = new Thread(new PiPer(this.mainVTDNav.toNormalizedString(this.mainVTDNav.getAttrVal("href"))));
            es.execute(t);
        }
        es.shutdown();
        log.debug((Object)"Waiting threads");
        es.awaitTermination(10L, TimeUnit.MINUTES);
        log.debug((Object)"Finished writing project");
        this.writer.write("</doc>");
        this.writer.close();
        return this.writer.toString();
    }

    private VTDNav setNavigator(String httpUrl) {
        if (httpUrl.contains("gtr.gtr")) {
            httpUrl = httpUrl.replace("gtr.gtr", "gtr");
        }
        VTDGen vg_tmp = new VTDGen();
        this.connector = new HttpConnector();
        try {
            byte[] bytes = this.connector.getInputSource(httpUrl).getBytes("UTF-8");
            vg_tmp.setDoc(bytes);
            vg_tmp.parse(false);
            return vg_tmp.getNav();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private int evalXpath(VTDNav fragmentVTDNav, String xPath) throws Exception {
        AutoPilot ap_tmp = new AutoPilot(fragmentVTDNav);
        ap_tmp.selectXPath(xPath);
        return ap_tmp.evalXPath();
    }

    private void writeFragment(VTDNav nav) throws Exception {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        nav.dumpFragment((OutputStream)b);
        String ret = b.toString();
        b.reset();
        this.writer.write(ret);
    }

    private void writeNewTagAndInfo(VTDNav vn, String xPath, String xmlOpenTag, String xmlCloseTag, String attrName) throws Exception {
        int nav_res = this.evalXpath(vn, xPath);
        if (nav_res != -1) {
            String tmp = xmlOpenTag;
            tmp = attrName != null ? tmp + vn.toNormalizedString(vn.getAttrVal(attrName)) : tmp + StringEscapeUtils.escapeXml11((String)vn.toNormalizedString(vn.getText()));
            tmp = tmp + xmlCloseTag;
            this.writer.write(tmp);
        }
    }

    private class ProcessFunder
    implements Runnable {
        private VTDNav vn;

        public ProcessFunder(String httpURL) {
            if (httpURL.contains("gtr.gtr")) {
                httpURL = httpURL.replace("gtr.gtr", "gtr");
            }
            this.vn = Gtr2Helper.this.setNavigator(httpURL);
        }

        @Override
        public void run() {
            try {
                AutoPilot ap = new AutoPilot(this.vn);
                Gtr2Helper.this.writeFragment(this.vn);
                ap.selectXPath(".//link[@rel='FUNDER']");
                while (ap.evalXPath() != -1) {
                    VTDNav tmp_vn = Gtr2Helper.this.setNavigator(this.vn.toNormalizedString(this.vn.getAttrVal("href")));
                    Gtr2Helper.this.writeNewTagAndInfo(tmp_vn, "//name", "<funder> <name>", "</name></funder>", null);
                }
            }
            catch (Throwable e) {
                log.debug((Object)("Eccezione in Funder" + e.getMessage()));
            }
        }
    }

    private class Org
    implements Runnable {
        private String[] tags;
        private VTDNav vn;

        public Org(String httpURL, String[] tags) {
            if (httpURL.contains("gtr.gtr")) {
                httpURL = httpURL.replace("gtr.gtr", "gtr");
            }
            this.vn = Gtr2Helper.this.setNavigator(httpURL);
            this.tags = tags;
        }

        @Override
        public void run() {
            try {
                Gtr2Helper.this.writeNewTagAndInfo(this.vn, "//name", this.tags[0] + "<name>", "</name>", null);
                this.vn.toElement(0);
                Gtr2Helper.this.writeNewTagAndInfo(this.vn, "//country", "<country>", "</country>", null);
                this.vn.toElement(0);
                Gtr2Helper.this.writeNewTagAndInfo(this.vn, ".", "<id>", "</id>" + this.tags[1], "id");
            }
            catch (Throwable e) {
                log.debug((Object)("Exception in  Org " + e.getMessage()));
            }
        }
    }

    private class PiPer
    implements Runnable {
        private VTDNav vn;

        public PiPer(String httpURL) {
            if (httpURL.contains("gtr.gtr")) {
                httpURL = httpURL.replace("gtr.gtr", "gtr");
            }
            this.vn = Gtr2Helper.this.setNavigator(httpURL);
        }

        @Override
        public void run() {
            try {
                Gtr2Helper.this.writeFragment(this.vn);
            }
            catch (Throwable e) {
                log.debug((Object)("Exception in  PiPer " + e.getMessage()));
            }
        }
    }
}

