/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.projects.gtr2;

import com.ximpleware.AutoPilot;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.data.collector.plugins.HttpConnector;
import eu.dnetlib.data.collector.plugins.projects.gtr2.Gtr2Helper;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Gtr2ProjectsIterator
implements Iterator<String> {
    public static final String TERMINATOR = "ARNOLD";
    public static final int WAIT_END_SECONDS = 600;
    public static final int PAGE_SZIE = 20;
    private static final Log log = LogFactory.getLog(Gtr2ProjectsIterator.class);
    private String queryURL;
    private int total = -1;
    private int startFromPage = 1;
    private int endAtPage;
    private VTDGen vg;
    private VTDNav vn;
    private AutoPilot ap;
    private String namespaces;
    private boolean incremental = false;
    private DateTime fromDate;
    private DateTimeFormatter simpleDateTimeFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private ArrayBlockingQueue<String> projects = new ArrayBlockingQueue(20);
    private final ExecutorService es = Executors.newFixedThreadPool(20);
    private String nextElement = "<doc></doc>";
    private HttpConnector connector;

    @Override
    public boolean hasNext() {
        return !this.nextElement.equals(TERMINATOR);
    }

    @Override
    public String next() {
        try {
            String string = this.nextElement;
            return string;
        }
        finally {
            try {
                this.nextElement = this.projects.poll(600L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Gtr2ProjectsIterator(String baseUrl, String fromDate) throws CollectorServiceException {
        this.prepare(baseUrl, fromDate);
        this.fillInfo(true);
    }

    public Gtr2ProjectsIterator(String baseUrl, String fromDate, int startFromPage, int endAtPage) throws CollectorServiceException {
        this.prepare(baseUrl, fromDate);
        this.setStartFromPage(startFromPage);
        this.setEndAtPage(endAtPage);
        this.fillInfo(false);
    }

    private void prepare(String baseUrl, String fromDate) {
        this.connector = new HttpConnector();
        this.queryURL = baseUrl + "/projects";
        this.vg = new VTDGen();
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        if (this.incremental) {
            this.fromDate = DateTime.parse((String)fromDate, (DateTimeFormatter)this.simpleDateTimeFormatter);
            log.debug((Object)("fromDate string: " + fromDate + " -- parsed: " + this.fromDate.toString()));
        }
    }

    private void fillInfo(boolean all) throws CollectorServiceException {
        try {
            byte[] bytes = this.connector.getInputSource(this.queryURL).getBytes("UTF-8");
            this.vg.setDoc(bytes);
            this.vg.parse(false);
            this.initParser();
            String hitCount = this.vn.toNormalizedString(this.vn.getAttrVal("totalSize"));
            String totalPages = this.vn.toNormalizedString(this.vn.getAttrVal("totalPages"));
            this.namespaces = "xmlns:ns1=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns1")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns2=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns2")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns3=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns3")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns4=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns4")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns5=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns5")) + "\" ";
            this.namespaces = this.namespaces + "xmlns:ns6=\"" + this.vn.toNormalizedString(this.vn.getAttrVal("ns6")) + "\" ";
            if (all) {
                this.setEndAtPage(Integer.parseInt(totalPages));
                this.total = Integer.parseInt(hitCount);
            }
            Thread ft = new Thread(new FillProjectList());
            ft.start();
            log.debug((Object)("Expected number of pages: " + (this.endAtPage - this.startFromPage + 1)));
        }
        catch (NumberFormatException e) {
            log.error((Object)"Cannot set the total count or the number of pages");
            throw new CollectorServiceException((Throwable)e);
        }
        catch (Throwable e) {
            throw new CollectorServiceException(e);
        }
    }

    private void initParser() {
        this.vn = this.vg.getNav();
        this.ap = new AutoPilot(this.vn);
    }

    public String getQueryURL() {
        return this.queryURL;
    }

    public void setQueryURL(String queryURL) {
        this.queryURL = queryURL;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getEndAtPage() {
        return this.endAtPage;
    }

    public void setEndAtPage(int endAtPage) {
        this.endAtPage = endAtPage;
        log.debug((Object)("Overriding endAtPage to " + endAtPage));
    }

    public VTDGen getVg() {
        return this.vg;
    }

    public void setVg(VTDGen vg) {
        this.vg = vg;
    }

    public VTDNav getVn() {
        return this.vn;
    }

    public void setVn(VTDNav vn) {
        this.vn = vn;
    }

    public AutoPilot getAp() {
        return this.ap;
    }

    public void setAp(AutoPilot ap) {
        this.ap = ap;
    }

    public String getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(String namespaces) {
        this.namespaces = namespaces;
    }

    public int getStartFromPage() {
        return this.startFromPage;
    }

    public void setStartFromPage(int startFromPage) {
        this.startFromPage = startFromPage;
        log.debug((Object)("Overriding startFromPage to " + startFromPage));
    }

    static /* synthetic */ int access$100(Gtr2ProjectsIterator x0) {
        return x0.startFromPage;
    }

    private class ParseProject
    implements Runnable {
        VTDNav vn1;
        VTDGen vg1;
        private String projectRef;

        public ParseProject(String projectHref) {
            if (projectHref.contains("gtr.gtr")) {
                projectHref = projectHref.replace("gtr.gtr", "gtr");
            }
            this.projectRef = projectHref;
            log.debug((Object)("strat " + this.projectRef));
            this.vg1 = new VTDGen();
            try {
                byte[] bytes = Gtr2ProjectsIterator.this.connector.getInputSource(this.projectRef).getBytes("UTF-8");
                this.vg1.setDoc(bytes);
                this.vg1.parse(false);
                this.vn1 = this.vg1.getNav();
            }
            catch (Throwable e) {
                log.error((Object)("Exception processing " + this.projectRef + "\n" + e.getMessage()));
            }
            log.debug((Object)("end " + this.projectRef));
        }

        private int projectsUpdate(String attr) throws CollectorServiceException {
            try {
                int index = this.vn1.getAttrVal(attr);
                if (index != -1) {
                    String d = this.vn1.toNormalizedString(index);
                    DateTime recordDate = DateTime.parse((String)d.substring(0, d.indexOf("T")), (DateTimeFormatter)Gtr2ProjectsIterator.this.simpleDateTimeFormatter);
                    if (recordDate.isAfter((ReadableInstant)Gtr2ProjectsIterator.this.fromDate)) {
                        log.debug((Object)"New project to collect");
                        return index;
                    }
                    return -1;
                }
                return index;
            }
            catch (Throwable e) {
                throw new CollectorServiceException(e);
            }
        }

        private String collectProject() throws CollectorServiceException {
            try {
                int p = this.vn1.getAttrVal("href");
                String projectHref = this.vn1.toNormalizedString(p);
                log.debug((Object)("collecting project at " + projectHref));
                Gtr2Helper gtr2Helper = new Gtr2Helper();
                String projectPackage = gtr2Helper.processProject(this.vn1, Gtr2ProjectsIterator.this.namespaces);
                return projectPackage;
            }
            catch (Throwable e) {
                throw new CollectorServiceException(e);
            }
        }

        private boolean add(String attr) throws CollectorServiceException {
            return this.projectsUpdate(attr) != -1;
        }

        @Override
        public void run() {
            log.debug((Object)("Getting project info from " + this.projectRef));
            try {
                if (!Gtr2ProjectsIterator.this.incremental || Gtr2ProjectsIterator.this.incremental && (this.add("created") || this.add("updated"))) {
                    Gtr2ProjectsIterator.this.projects.put(this.collectProject());
                    log.debug((Object)("Project enqueued " + this.projectRef));
                }
            }
            catch (Throwable e) {
                log.error((Object)("Error on ParseProject " + e.getMessage()));
                throw new CollectorServiceRuntimeException(e);
            }
        }
    }

    private class FillProjectList
    implements Runnable {
        private boolean morePages = true;
        private int pageNumber = Gtr2ProjectsIterator.access$100(Gtr2ProjectsIterator.this);

        private FillProjectList() {
        }

        @Override
        public void run() {
            String resultPageUrl = "";
            try {
                do {
                    int res;
                    resultPageUrl = this.getNextPageUrl();
                    log.debug((Object)("Page: " + resultPageUrl));
                    Gtr2ProjectsIterator.this.vg.clear();
                    byte[] bytes = Gtr2ProjectsIterator.this.connector.getInputSource(resultPageUrl).getBytes("UTF-8");
                    Gtr2ProjectsIterator.this.vg.setDoc(bytes);
                    Gtr2ProjectsIterator.this.vg.parse(false);
                    Gtr2ProjectsIterator.this.initParser();
                    Gtr2ProjectsIterator.this.ap.selectXPath("//project");
                    while ((res = Gtr2ProjectsIterator.this.ap.evalXPath()) != -1) {
                        String projectHref = Gtr2ProjectsIterator.this.vn.toNormalizedString(Gtr2ProjectsIterator.this.vn.getAttrVal("href"));
                        Thread t = new Thread(new ParseProject(projectHref));
                        t.setName("Thread for " + res);
                        Gtr2ProjectsIterator.this.es.execute(t);
                    }
                    Gtr2ProjectsIterator.this.ap.resetXPath();
                } while (this.morePages);
                Gtr2ProjectsIterator.this.es.shutdown();
                Gtr2ProjectsIterator.this.es.awaitTermination(600L, TimeUnit.SECONDS);
                Gtr2ProjectsIterator.this.projects.put(Gtr2ProjectsIterator.TERMINATOR);
            }
            catch (Throwable e) {
                log.error((Object)("Exception processing " + resultPageUrl + "\n" + e.getMessage()));
            }
        }

        private String getNextPageUrl() {
            String url = Gtr2ProjectsIterator.this.queryURL + "?p=" + this.pageNumber;
            if (this.pageNumber == Gtr2ProjectsIterator.this.endAtPage) {
                this.morePages = false;
            }
            ++this.pageNumber;
            return url;
        }
    }
}

