package eu.dnetlib.data.collector.plugins.croris;

import org.apache.commons.lang3.math.NumberUtils;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;

public class CrorisCollectorPlugin extends AbstractCollectorPlugin {

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
		throws CollectorServiceException {

		final int pageSize = NumberUtils.toInt(interfaceDescriptor.getParams().get("pageSize"));

		return () -> new CrorisIterator(interfaceDescriptor.getBaseUrl(), pageSize);
	}

}
