/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.croris;

import eu.dnetlib.data.collector.plugins.utils.JsonUtils;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class CrorisIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(CrorisIterator.class);
    private String nextUrl;
    private final Queue<String> queue = new PriorityBlockingQueue<String>();

    public CrorisIterator(String baseUrl, int pageSize) {
        try {
            this.nextUrl = this.invokeUrl(baseUrl + "?pageNumber=1&pageSize=" + pageSize);
        }
        catch (CollectorServiceException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String next() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            String string;
            try {
                string = this.queue.poll();
            }
            catch (Throwable throwable) {
                while (this.queue.isEmpty() && StringUtils.isNotBlank((CharSequence)this.nextUrl)) {
                    try {
                        this.nextUrl = this.invokeUrl(this.nextUrl);
                    }
                    catch (CollectorServiceException e) {
                        throw new IllegalStateException(e);
                    }
                }
                throw throwable;
            }
            while (this.queue.isEmpty() && StringUtils.isNotBlank((CharSequence)this.nextUrl)) {
                try {
                    this.nextUrl = this.invokeUrl(this.nextUrl);
                }
                catch (CollectorServiceException e) {
                    throw new IllegalStateException(e);
                }
            }
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String invokeUrl(String url) throws CollectorServiceException {
        String next = null;
        log.info((Object)("Calling url: " + url));
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpGet req = new HttpGet(url);
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)req);){
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                String xml = new JsonUtils().convertToXML(content);
                Document doc = DocumentHelper.parseText((String)xml);
                for (Object n : doc.selectNodes("//projekti")) {
                    this.queue.add(((Node)n).asXML());
                }
                next = doc.valueOf("//next/href");
            }
            String string = next;
            return string;
        }
        catch (Throwable e) {
            log.warn((Object)("Error calling url: " + url), e);
            throw new CollectorServiceException("Error calling url: " + url, e);
        }
    }
}

