/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.datacite;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.plugin.CollectorPlugin;
import eu.dnetlib.data.collector.plugins.datacite.DataciteESIterator;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.text.ParseException;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataciteCollectorPlugin
extends AbstractCollectorPlugin
implements CollectorPlugin {
    private static final Log log = LogFactory.getLog(DataciteCollectorPlugin.class);
    private DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        String baseurl = interfaceDescriptor.getBaseUrl();
        if (StringUtils.isBlank((CharSequence)baseurl)) {
            throw new CollectorServiceException("baseUrl cannot be empty");
        }
        long timestamp = 0L;
        if (StringUtils.isNotBlank((CharSequence)fromDate)) {
            try {
                Date date = DateUtils.parseDate((String)fromDate, (String[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd'T'HH:mm:ss.SSSX", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ss.SX"});
                timestamp = date.toInstant().toEpochMilli() / 1000L;
                log.info((Object)("Querying for Datacite records from timestamp " + timestamp + " (date was " + fromDate + ")"));
            }
            catch (ParseException e) {
                throw new CollectorServiceException((Throwable)e);
            }
        }
        long finalTimestamp = timestamp;
        return () -> {
            try {
                return new DataciteESIterator(finalTimestamp, baseurl);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

