/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.gtr2;

import eu.dnetlib.data.collector.plugin.AbstractCollectorPlugin;
import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.InterfaceDescriptor;
import java.util.Iterator;

public abstract class AbstractGtr2CollectorPlugin
extends AbstractCollectorPlugin {
    public final Iterable<String> collect(InterfaceDescriptor interfaceDescriptor, String fromDate, String untilDate) throws CollectorServiceException {
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorServiceException("Invalid date (YYYY-MM-DD): " + fromDate);
        }
        String baseUrl = interfaceDescriptor.getBaseUrl();
        String startPage = (String)interfaceDescriptor.getParams().get("startPage");
        String endPage = (String)interfaceDescriptor.getParams().get("endPage");
        return () -> {
            try {
                return this.createIterator(baseUrl, fromDate, startPage, endPage);
            }
            catch (CollectorServiceException e) {
                throw new RuntimeException(e);
            }
        };
    }

    protected abstract Iterator<String> createIterator(String var1, String var2, String var3, String var4) throws CollectorServiceException;
}

