package eu.dnetlib.data.collector.plugins.gtr2;

import java.util.Iterator;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import eu.dnetlib.data.collector.rmi.CollectorServiceException;

/**
 * Plugin to collect metadata record about publications via the UKRI grt2 API.
 * <p>
 * Documentation : http://gtr.ukri.org/resources/api.html.
 * </p>
 * <p>
 * BaseURL: https://gtr.ukri.org/gtr/api The results returned by the API are XMLs.
 * </p>
 * <p>
 * Pagination: TO BE DEFINED. Exceeding the number of pages available will result in a HTTP response code of 404
 * </p>
 *
 * @author alessia
 */
public class Gtr2PublicationsCollectorPlugin extends AbstractGtr2CollectorPlugin {

	@Override
	protected Iterator<String> createIterator(final String baseUrl, final String fromDate, final String startPage, final String endPage)
		throws CollectorServiceException {
		return new Gtr2Iterator(baseUrl, fromDate, startPage, endPage) {

			@Override
			protected String urlForPage(final String baseUrl, final int pageNumber) {
				return baseUrl + "/outcomes/publications?p=" + pageNumber;
			}

			@Override
			protected String xpathForEntity() {
				return "//*[local-name() = 'publication']";
			}

			@Override
			protected String expandMainEntity(final Element mainEntity) {
				final Element newRoot = DocumentHelper.createElement("doc");
				newRoot.add(mainEntity);
				addLinkedEntities(mainEntity, "PROJECT", newRoot, o -> asProjectElement(o));
				return DocumentHelper.createDocument(newRoot).asXML();
			}

			private Element asProjectElement(final Document doc) {
				final Element newOrg = DocumentHelper.createElement("project");
				newOrg.addElement("id").setText(doc.valueOf("/*/@*[local-name()='id']"));
				newOrg.addElement("code").setText(doc.valueOf("//*[local-name()='identifier' and @*[local-name()='type'] = 'RCUK']"));
				newOrg.addElement("title").setText(doc.valueOf("//*[local-name()='title']"));
				return newOrg;
			}

		};
	}

}
