/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transformation.ui;

import eu.dnetlib.data.transformation.service.DataTransformerFactory;
import eu.dnetlib.data.transformation.service.SimpleDataTransformer;
import eu.dnetlib.data.transformation.ui.TransformerUtils;
import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.functionality.modular.ui.error.ErrorMessage;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class DataTransformationController
extends AbstractInspectorController {
    @Resource
    private DataTransformerFactory dataTransformerFactory;
    @Resource
    private TransformerUtils transformerUtils;

    @RequestMapping(value={"/inspector/transform.do"})
    public void transform(Model model, @RequestParam(value="rule", required=false) String ruleId, @RequestParam(value="record", required=false) String record) throws Exception {
        model.addAttribute("rules", this.transformerUtils.obtainRuleProfiles(ruleId));
        if (ruleId != null && record != null) {
            SimpleDataTransformer transformer = this.dataTransformerFactory.createTransformer(ruleId);
            model.addAttribute("input", (Object)record);
            model.addAttribute("output", (Object)transformer.evaluate(record));
        }
    }

    @RequestMapping(value={"/ui/transform/transform.do"})
    public void transform(HttpServletResponse res, @RequestParam(value="rule", required=true) String ruleId, @RequestBody String record) throws ISLookUpDocumentNotFoundException, ISLookUpException, IOException {
        res.setContentType("text/xml");
        IOUtils.write((String)this.dataTransformerFactory.createTransformer(ruleId).evaluate(record), (OutputStream)res.getOutputStream());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessage handleException(HttpServletRequest req, Exception e) {
        return new ErrorMessage(e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
    }
}

