package eu.dnetlib.enabling.datasources.common;

import java.sql.Date;
import java.util.Set;
import javax.persistence.*;

@MappedSuperclass
public class Organization<DS extends Datasource<?, ?>> {

	@Id
	protected String id;
	protected String legalshortname;
	protected String legalname;
	protected String websiteurl;
	protected String logourl;

	@Column(name = "ec_legalbody")
	protected Boolean eclegalbody;

	@Column(name = "ec_legalperson")
	protected Boolean eclegalperson;

	@Column(name = "ec_nonprofit")
	protected Boolean ecnonprofit;

	@Column(name = "ec_researchorganization")
	protected Boolean ecresearchorganization;

	@Column(name = "ec_highereducation")
	protected Boolean echighereducation;

	@Column(name = "ec_internationalorganizationeurinterests")
	protected Boolean ecinternationalorganizationeurinterests;

	@Column(name = "ec_internationalorganization")
	protected Boolean ecinternationalorganization;

	@Column(name = "ec_enterprise")
	protected Boolean ecenterprise;

	@Column(name = "ec_smevalidated")
	protected Boolean ecsmevalidated;

	@Column(name = "ec_nutscode")
	protected Boolean ecnutscode;

	protected String country;
	protected String collectedfrom;

	protected Date dateofcollection;
	protected String provenanceaction;

	@ManyToMany(cascade = { CascadeType.PERSIST, CascadeType.MERGE }, fetch = FetchType.EAGER, mappedBy = "organizations")
	protected Set<DS> datasources;

	public Organization() {}

	public String getId() {
		return id;
	}

	public String getLegalshortname() {
		return legalshortname;
	}

	public String getLegalname() {
		return legalname;
	}

	public String getWebsiteurl() {
		return websiteurl;
	}

	public String getLogourl() {
		return logourl;
	}

	public Boolean isEclegalbody() {
		return eclegalbody;
	}

	public Boolean isEclegalperson() {
		return eclegalperson;
	}

	public Boolean isEcnonprofit() {
		return ecnonprofit;
	}

	public Boolean isEcresearchorganization() {
		return ecresearchorganization;
	}

	public Boolean isEchighereducation() {
		return echighereducation;
	}

	public Boolean isEcinternationalorganizationeurinterests() {
		return ecinternationalorganizationeurinterests;
	}

	public Boolean isEcinternationalorganization() {
		return ecinternationalorganization;
	}

	public Boolean isEcenterprise() {
		return ecenterprise;
	}

	public Boolean isEcsmevalidated() {
		return ecsmevalidated;
	}

	public Boolean isEcnutscode() {
		return ecnutscode;
	}

	public String getCountry() {
		return country;
	}

	public String getCollectedfrom() {
		return collectedfrom;
	}

	public Date getDateofcollection() {
		return dateofcollection;
	}

	public String getProvenanceaction() {
		return provenanceaction;
	}

	public Organization<DS> setId(final String id) {
		this.id = id;
		return this;
	}

	public Organization<DS> setLegalshortname(final String legalshortname) {
		this.legalshortname = legalshortname;
		return this;
	}

	public Organization<DS> setLegalname(final String legalname) {
		this.legalname = legalname;
		return this;
	}

	public Organization<DS> setWebsiteurl(final String websiteurl) {
		this.websiteurl = websiteurl;
		return this;
	}

	public Organization<DS> setLogourl(final String logourl) {
		this.logourl = logourl;
		return this;
	}

	public Organization<DS> setEclegalbody(final Boolean eclegalbody) {
		this.eclegalbody = eclegalbody;
		return this;
	}

	public Organization<DS> setEclegalperson(final Boolean eclegalperson) {
		this.eclegalperson = eclegalperson;
		return this;
	}

	public Organization<DS> setEcnonprofit(final Boolean ecnonprofit) {
		this.ecnonprofit = ecnonprofit;
		return this;
	}

	public Organization<DS> setEcresearchorganization(final Boolean ecresearchorganization) {
		this.ecresearchorganization = ecresearchorganization;
		return this;
	}

	public Organization<DS> setEchighereducation(final Boolean echighereducation) {
		this.echighereducation = echighereducation;
		return this;
	}

	public Organization<DS> setEcinternationalorganizationeurinterests(final Boolean ecinternationalorganizationeurinterests) {
		this.ecinternationalorganizationeurinterests = ecinternationalorganizationeurinterests;
		return this;
	}

	public Organization<DS> setEcinternationalorganization(final Boolean ecinternationalorganization) {
		this.ecinternationalorganization = ecinternationalorganization;
		return this;
	}

	public Organization<DS> setEcenterprise(final Boolean ecenterprise) {
		this.ecenterprise = ecenterprise;
		return this;
	}

	public Organization<DS> setEcsmevalidated(final Boolean ecsmevalidated) {
		this.ecsmevalidated = ecsmevalidated;
		return this;
	}

	public Organization<DS> setEcnutscode(final Boolean ecnutscode) {
		this.ecnutscode = ecnutscode;
		return this;
	}

	public Organization<DS> setCountry(final String country) {
		this.country = country;
		return this;
	}

	public Organization<DS> setCollectedfrom(final String collectedfrom) {
		this.collectedfrom = collectedfrom;
		return this;
	}

	public Organization<DS> setDateofcollection(final Date dateofcollection) {
		this.dateofcollection = dateofcollection;
		return this;
	}

	public Organization<DS> setProvenanceaction(final String provenanceaction) {
		this.provenanceaction = provenanceaction;
		return this;
	}

	public Set<DS> getDatasources() {
		return datasources;
	}

	public void setDatasources(final Set<DS> datasources) {
		this.datasources = datasources;
	}

}
