package eu.dnetlib.enabling.datasources.common;

import java.util.List;

public interface DatasourceManagerCommon<DS extends Datasource<?, ?>, API extends Api<?>> {

	DS getDs(String id) throws DatasourceManagerException;

	List<? extends API> getApis(String dsId) throws DatasourceManagerException;

	void deleteDs(String dsId) throws DatasourceManagerException;

	void deleteApi(String dsId, String apiId) throws DatasourceManagerException;

	void addApi(API api) throws DatasourceManagerException;

	void setManaged(String id, boolean managed) throws DatasourceManagerException;

	boolean isManaged(String id) throws DatasourceManagerException;

	void saveDs(DS datasource) throws DatasourceManagerException;

	void updateCompliance(String dsId, String apiId, String compliance, boolean override) throws DatasourceManagerException;

}
