package eu.dnetlib.enabling.datasources.common;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface LocalDatasourceManager<DS extends Datasource<?, ?>, API extends Api<?>> extends DatasourceManagerCommon<DS, API> {

	List<? extends SearchApisEntry> searchApis(String field, Object value) throws DatasourceManagerException;

	List<? extends BrowsableField> listBrowsableFields() throws DatasourceManagerException;

	List<? extends BrowseTerm> browseField(String field) throws DatasourceManagerException;

	void setActive(String dsId, String apiId, boolean active) throws DatasourceManagerException;

	boolean isActive(String dsId, String apiId) throws DatasourceManagerException;

	void setLastCollectionInfo(String dsId, String apiId, String mdId, Integer size, Date date) throws DatasourceManagerException;

	void setLastAggregationInfo(String dsId, String apiId, String mdId, Integer size, Date date) throws DatasourceManagerException;

	void setLastDownloadInfo(String dsId, String apiId, String objId, Integer size, Date date) throws DatasourceManagerException;

	void updateApiDetails(String dsId, String apiId, String baseUrl, Map<String, String> params) throws DatasourceManagerException;

	boolean isRemovable(String dsId, String apiId) throws DatasourceManagerException;

}
