package eu.dnetlib.enabling.datasources.common;

import java.sql.Date;
import java.util.Objects;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;

import com.google.common.collect.ComparisonChain;
import com.google.gson.Gson;

/**
 * Api
 */
@MappedSuperclass
public class Api<AP extends ApiParam> implements Comparable<Api<AP>> {

	@Id
	protected String id = null;
	protected String protocol = null;
	protected String datasource = null;
	protected String contentdescription = null;
	protected Boolean active = false;
	protected Boolean removable = false;
	protected String typology = null;
	protected String compatibility;

	@Column(name = "metadata_identifier_path")
	protected String metadataIdentifierPath;

	@Column(name = "last_collection_total")
	protected Integer lastCollectionTotal;

	@Column(name = "last_collection_date")
	protected Date lastCollectionDate;

	@Column(name = "last_collection_mdid")
	protected String lastCollectionMdid;

	@Column(name = "last_aggregation_total")
	protected Integer lastAggregationTotal;

	@Column(name = "last_aggregation_date")
	protected Date lastAggregationDate;

	@Column(name = "last_aggregation_mdid")
	protected String lastAggregationMdid;

	@Column(name = "last_download_total")
	protected Integer lastDownloadTotal;

	@Column(name = "last_download_date")
	protected Date lastDownloadDate;

	@Column(name = "last_download_objid")
	protected String lastDownloadObjid;

	@Column(name = "last_validation_job")
	protected String lastValidationJob;
	protected String baseurl = null;

	@OneToMany(mappedBy = "id.api", cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	protected Set<AP> apiParams;

	public Api() {}

	public String getId() {
		return id;
	}

	public String getProtocol() {
		return protocol;
	}

	public String getDatasource() {
		return datasource;
	}

	public String getContentdescription() {
		return contentdescription;
	}

	public Boolean getActive() {
		return active;
	}

	public Boolean getRemovable() {
		return removable;
	}

	public String getTypology() {
		return typology;
	}

	public String getCompatibility() {
		return compatibility;
	}

	public String getMetadataIdentifierPath() {
		return metadataIdentifierPath;
	}

	public Integer getLastCollectionTotal() {
		return lastCollectionTotal;
	}

	public Date getLastCollectionDate() {
		return lastCollectionDate;
	}

	public String getLastCollectionMdid() {
		return lastCollectionMdid;
	}

	public Integer getLastAggregationTotal() {
		return lastAggregationTotal;
	}

	public Date getLastAggregationDate() {
		return lastAggregationDate;
	}

	public String getLastAggregationMdid() {
		return lastAggregationMdid;
	}

	public Integer getLastDownloadTotal() {
		return lastDownloadTotal;
	}

	public Date getLastDownloadDate() {
		return lastDownloadDate;
	}

	public String getLastDownloadObjid() {
		return lastDownloadObjid;
	}

	public String getLastValidationJob() {
		return lastValidationJob;
	}

	public String getBaseurl() {
		return baseurl;
	}

	public Set<AP> getApiParams() {
		return apiParams;
	}

	public Api setId(final String id) {
		this.id = id;
		return this;
	}

	public Api setProtocol(final String protocol) {
		this.protocol = protocol;
		return this;
	}

	public Api setDatasource(final String datasource) {
		this.datasource = datasource;
		return this;
	}

	public Api setContentdescription(final String contentdescription) {
		this.contentdescription = contentdescription;
		return this;
	}

	public Api setActive(final Boolean active) {
		this.active = active;
		return this;
	}

	public Api setRemovable(final Boolean removable) {
		this.removable = removable;
		return this;
	}

	public Api setTypology(final String typology) {
		this.typology = typology;
		return this;
	}

	public Api setCompatibility(final String compatibility) {
		this.compatibility = compatibility;
		return this;
	}

	public Api setMetadataIdentifierPath(final String metadataIdentifierPath) {
		this.metadataIdentifierPath = metadataIdentifierPath;
		return this;
	}

	public Api setLastCollectionTotal(final Integer lastCollectionTotal) {
		this.lastCollectionTotal = lastCollectionTotal;
		return this;
	}

	public Api setLastCollectionDate(final Date lastCollectionDate) {
		this.lastCollectionDate = lastCollectionDate;
		return this;
	}

	public Api setLastCollectionMdid(final String lastCollectionMdid) {
		this.lastCollectionMdid = lastCollectionMdid;
		return this;
	}

	public Api setLastAggregationTotal(final Integer lastAggregationTotal) {
		this.lastAggregationTotal = lastAggregationTotal;
		return this;
	}

	public Api setLastAggregationDate(final Date lastAggregationDate) {
		this.lastAggregationDate = lastAggregationDate;
		return this;
	}

	public Api setLastAggregationMdid(final String lastAggregationMdid) {
		this.lastAggregationMdid = lastAggregationMdid;
		return this;
	}

	public Api setLastDownloadTotal(final Integer lastDownloadTotal) {
		this.lastDownloadTotal = lastDownloadTotal;
		return this;
	}

	public Api setLastDownloadDate(final Date lastDownloadDate) {
		this.lastDownloadDate = lastDownloadDate;
		return this;
	}

	public Api setLastDownloadObjid(final String lastDownloadObjid) {
		this.lastDownloadObjid = lastDownloadObjid;
		return this;
	}

	public Api setLastValidationJob(final String lastValidationJob) {
		this.lastValidationJob = lastValidationJob;
		return this;
	}

	public Api setBaseurl(final String baseurl) {
		this.baseurl = baseurl;
		return this;
	}

	public Api setApiParams(final Set<AP> apiParams) {
		this.apiParams = apiParams;
		return this;
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o) { return true; }
		if (o == null || getClass() != o.getClass()) { return false; }
		final Api api = (Api) o;
		return Objects.equals(this.id, api.id);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.openaire.exporter.model.datasource.db.ApiInterface#hashCode()
	 */

	@Override
	public int hashCode() {
		return Objects.hash(id);
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

	@Override
	public int compareTo(final Api a) {
		return ComparisonChain.start()
				.compare(getId(), a.getId())
				.result();
	}

}
