/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.utils;

import com.google.common.collect.Lists;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.googlecode.protobuf.format.JsonFormat;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.proto.ResultProtos;
import eu.dnetlib.data.proto.TypeProtos;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.model.ProtoDocumentBuilder;
import eu.dnetlib.proto.utils.OAFProtoUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class PaceUtils {
    public static MapDocument result(Config config, String id, String title) {
        return PaceUtils.result(config, id, title, null, new ArrayList<String>(), null);
    }

    public static MapDocument result(Config config, String id, String title, String date) {
        return PaceUtils.result(config, id, title, date, new ArrayList<String>(), null);
    }

    public static MapDocument result(Config config, String id, String title, String date, List<String> pid) {
        return PaceUtils.result(config, id, title, date, pid, null);
    }

    public static MapDocument result(Config config, String id, String title, String date, String pid) {
        return PaceUtils.result(config, id, title, date, pid, null);
    }

    public static MapDocument result(Config config, String id, String title, String date, String pid, List<String> authors) {
        return PaceUtils.result(config, id, title, date, Lists.newArrayList((Object[])new String[]{pid}), authors);
    }

    public static MapDocument result(Config config, String id, String title, String date, List<String> pid, List<String> authors) {
        ResultProtos.Result.Metadata.Builder metadata = ResultProtos.Result.Metadata.newBuilder();
        if (!StringUtils.isBlank((CharSequence)title)) {
            metadata.addTitle(OAFProtoUtils.getStruct(title, OAFProtoUtils.getQualifier("main title", "dnet:titles")));
            metadata.addTitle(OAFProtoUtils.getStruct(RandomStringUtils.randomAlphabetic((int)10), OAFProtoUtils.getQualifier("alternative title", "dnet:titles")));
        }
        if (!StringUtils.isBlank((CharSequence)date)) {
            metadata.setDateofacceptance(OAFProtoUtils.sf(date));
        }
        OafProtos.OafEntity.Builder entity = OAFProtoUtils.oafEntity(id, TypeProtos.Type.result);
        ResultProtos.Result.Builder result = ResultProtos.Result.newBuilder().setMetadata(metadata);
        if (authors != null) {
            result.getMetadataBuilder().addAllAuthor((Iterable)IntStream.range(0, authors.size()).mapToObj(i -> OAFProtoUtils.author((String)authors.get(i), i)).collect(Collectors.toCollection(LinkedList::new)));
        }
        entity.setResult(result);
        if (pid != null) {
            for (String p : pid) {
                if (StringUtils.isBlank((CharSequence)p)) continue;
                entity.addPid(OAFProtoUtils.sp(p, "doi"));
            }
        }
        OafProtos.OafEntity build = entity.build();
        return ProtoDocumentBuilder.newInstance((String)id, (GeneratedMessage)build, (List)config.model());
    }

    public static MapDocument asMapDocument(DedupConfig conf, String json) {
        OafProtos.OafEntity.Builder b = OafProtos.OafEntity.newBuilder();
        try {
            JsonFormat.merge((CharSequence)json, (Message.Builder)b);
        }
        catch (JsonFormat.ParseException e) {
            System.out.println("**************************** " + json);
            throw new IllegalArgumentException(e);
        }
        return ProtoDocumentBuilder.newInstance((String)b.getId(), (GeneratedMessage)b.build(), (List)conf.getPace().getModel());
    }
}

