/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.util.PaceException;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ConnectedComponent
implements Serializable {
    private Set<MapDocument> docs;
    private String id;

    public ConnectedComponent() {
    }

    public ConnectedComponent(String id, Set<MapDocument> docs) {
        this.id = id;
        this.docs = docs;
    }

    public Set<MapDocument> getDocs() {
        return this.docs;
    }

    public void setDocs(Set<MapDocument> docs) {
        this.docs = docs;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void initializeID() {
        if (this.docs.size() > 1) {
            String ccID = this.getMin(this.docs.stream().map(doc -> doc.getIdentifier()).collect(Collectors.toList()));
            String prefix = ccID.split("\\|")[0];
            String id = ccID.split("::")[1];
            this.id = prefix + "|dedup_______::" + id;
        } else {
            this.id = this.docs.iterator().next().getIdentifier();
        }
    }

    @JsonIgnore
    public String getMin(List<String> ids) {
        String min = ids.get(0);
        for (String id : ids) {
            if (min.compareTo(id) <= 0) continue;
            min = id;
        }
        return min;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new PaceException("Failed to create Json: ", (Throwable)e);
        }
    }
}

