/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.util.PaceException;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ConnectedComponent
implements Serializable {
    private Set<MapDocument> docs;
    private String id;
    private Map<String, Field> fieldMap;

    public ConnectedComponent() {
    }

    public ConnectedComponent(Set<MapDocument> docs) {
        this.docs = docs;
        this.id = this.createID(docs);
        this.fieldMap = this.chooseFields(docs);
    }

    public Set<MapDocument> getDocs() {
        return this.docs;
    }

    public void setDocs(Set<MapDocument> docs) {
        this.docs = docs;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Map<String, Field> chooseFields(Set<MapDocument> docs) {
        int maxLength = 0;
        Map<String, Object> maxFieldMap = new HashMap<String, Field>();
        for (MapDocument doc : docs) {
            if (doc.toString().length() <= maxLength) continue;
            maxFieldMap = doc.getFieldMap();
            maxLength = doc.toString().length();
        }
        return maxFieldMap;
    }

    public String createID(Set<MapDocument> docs) {
        if (docs.size() > 1) {
            String ccID = this.getMin(docs.stream().map(doc -> doc.getIdentifier()).collect(Collectors.toList()));
            String prefix = ccID.split("\\|")[0];
            String id = ccID.split("::")[1];
            return prefix + "|dedup_______::" + id;
        }
        return docs.iterator().next().getIdentifier();
    }

    @JsonIgnore
    public String getMin(List<String> ids) {
        String min = ids.get(0);
        for (String id : ids) {
            if (min.compareTo(id) <= 0) continue;
            min = id;
        }
        return min;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new PaceException("Failed to create Json: ", (Throwable)e);
        }
    }

    public Map<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(Map<String, Field> fieldMap) {
        this.fieldMap = fieldMap;
    }
}

