/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.jobs;

import eu.dnetlib.Deduper;
import eu.dnetlib.jobs.AbstractSparkJob;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.util.MapDocumentUtil;
import eu.dnetlib.pace.utils.Utility;
import eu.dnetlib.support.ArgumentApplicationParser;
import eu.dnetlib.support.Relation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkCreateDedupEntity
extends AbstractSparkJob {
    private static final Logger log = LoggerFactory.getLogger(SparkCreateDedupEntity.class);

    public SparkCreateDedupEntity(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(Utility.readResource("/jobs/parameters/createDedupEntity_parameters.json", SparkCreateDedupEntity.class));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkCreateDedupEntity(parser, SparkCreateDedupEntity.getSparkSession(conf)).run();
    }

    @Override
    public void run() throws IOException {
        String entitiesPath = this.parser.get("entitiesPath");
        String workingPath = this.parser.get("workingPath");
        String dedupConfPath = this.parser.get("dedupConfPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        log.info("entitiesPath:  '{}'", (Object)entitiesPath);
        log.info("workingPath:   '{}'", (Object)workingPath);
        log.info("dedupConfPath: '{}'", (Object)dedupConfPath);
        log.info("numPartitions: '{}'", (Object)numPartitions);
        DedupConfig dedupConf = DedupConfig.load((String)SparkCreateDedupEntity.readResource("/jobs/parameters/createDedupEntity_parameters.json", SparkCreateDedupEntity.class));
        JavaPairRDD entities = this.spark.read().textFile(entitiesPath).map((MapFunction & Serializable)it -> new Tuple2((Object)MapDocumentUtil.getJPathString((String)dedupConf.getWf().getIdPath(), (String)it), it), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.STRING())).toJavaRDD().mapToPair((PairFunction & Serializable)t -> t);
        JavaPairRDD mergeRels = this.spark.read().load(workingPath + "/mergerels").as(Encoders.bean(Relation.class)).toJavaRDD().mapToPair((PairFunction & Serializable)r -> new Tuple2((Object)r.getTarget(), r));
        JavaRDD dedupEntities = mergeRels.join(entities).mapToPair((PairFunction & Serializable)t -> new Tuple2((Object)((Relation)((Tuple2)t._2())._1()).getSource(), ((Tuple2)t._2())._2())).groupByKey().map((Function & Serializable)t -> Deduper.entityMerger((String)t._1(), ((Iterable)t._2()).iterator()));
        dedupEntities.saveAsTextFile(workingPath + "dedupentity");
    }
}

