/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.jobs;

import eu.dnetlib.Deduper;
import eu.dnetlib.jobs.AbstractSparkJob;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.util.MapDocumentUtil;
import eu.dnetlib.support.ArgumentApplicationParser;
import eu.dnetlib.support.Block;
import eu.dnetlib.support.Relation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkCreateSimRels
extends AbstractSparkJob {
    private static final Logger log = LoggerFactory.getLogger(SparkCreateSimRels.class);

    public SparkCreateSimRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(SparkCreateSimRels.readResource("/jobs/parameters/createSimRels_parameters.json", SparkCreateSimRels.class));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkCreateSimRels(parser, SparkCreateSimRels.getSparkSession(conf)).run();
    }

    @Override
    public void run() throws IOException {
        String entitiesPath = this.parser.get("entitiesPath");
        String workingPath = this.parser.get("workingPath");
        String dedupConfPath = this.parser.get("dedupConfPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        boolean useTree = Boolean.parseBoolean(this.parser.get("useTree"));
        log.info("entitiesPath:  '{}'", (Object)entitiesPath);
        log.info("workingPath:   '{}'", (Object)workingPath);
        log.info("dedupConfPath: '{}'", (Object)dedupConfPath);
        log.info("numPartitions: '{}'", (Object)numPartitions);
        log.info("useTree:       '{}'", (Object)useTree);
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)this.spark.sparkContext());
        DedupConfig dedupConfig = SparkCreateSimRels.loadDedupConfig(dedupConfPath);
        JavaPairRDD mapDocuments = sc.textFile(entitiesPath).mapToPair((PairFunction & Serializable)s -> {
            MapDocument d = MapDocumentUtil.asMapDocumentWithJPath((DedupConfig)dedupConfig, (String)s);
            return new Tuple2((Object)d.getIdentifier(), (Object)d);
        });
        JavaPairRDD<String, Block> blocks = Deduper.createSortedBlocks((JavaPairRDD<String, MapDocument>)mapDocuments, dedupConfig);
        JavaRDD<Relation> relations = useTree ? Deduper.computeRelations(sc, blocks, dedupConfig) : Deduper.computePublicationRelations(sc, blocks, dedupConfig);
        this.spark.createDataset(relations.rdd(), Encoders.bean(Relation.class)).write().mode(SaveMode.Overwrite).save(workingPath + "/simrels");
    }
}

