/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.jobs;

import eu.dnetlib.Deduper;
import eu.dnetlib.jobs.AbstractSparkJob;
import eu.dnetlib.jobs.SparkCreateSimRels;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldValueImpl;
import eu.dnetlib.pace.model.MapDocument;
import eu.dnetlib.pace.util.MapDocumentUtil;
import eu.dnetlib.support.ArgumentApplicationParser;
import eu.dnetlib.support.Block;
import eu.dnetlib.support.ConnectedComponent;
import eu.dnetlib.support.Relation;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkComputeStatistics
extends AbstractSparkJob {
    private static final Logger log = LoggerFactory.getLogger(SparkComputeStatistics.class);

    public SparkComputeStatistics(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(SparkComputeStatistics.readResource("/jobs/parameters/computeStatistics_parameters.json", SparkCreateSimRels.class));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkComputeStatistics(parser, SparkComputeStatistics.getSparkSession(conf)).run();
    }

    @Override
    public void run() throws IOException {
        String entitiesPath = this.parser.get("entitiesPath");
        String workingPath = this.parser.get("workingPath");
        String dedupConfPath = this.parser.get("dedupConfPath");
        String groundTruthFieldJPath = this.parser.get("groundTruthFieldJPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        log.info("entitiesPath:          '{}'", (Object)entitiesPath);
        log.info("workingPath:           '{}'", (Object)workingPath);
        log.info("numPartitions:         '{}'", (Object)numPartitions);
        log.info("dedupConfPath:         '{}'", (Object)dedupConfPath);
        log.info("groundTruthFieldJPath: '{}'", (Object)groundTruthFieldJPath);
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)this.spark.sparkContext());
        DedupConfig dedupConfig = SparkComputeStatistics.loadDedupConfig(dedupConfPath);
        JavaPairRDD mapDocuments = sc.textFile(entitiesPath).repartition(numPartitions).mapToPair((PairFunction & Serializable)s -> {
            MapDocument d = MapDocumentUtil.asMapDocumentWithJPath((DedupConfig)dedupConfig, (String)s);
            d.getFieldMap().put("groundTruth", new FieldValueImpl(Type.String, "groundTruth", (Object)MapDocumentUtil.getJPathString((String)groundTruthFieldJPath, (String)s)));
            return new Tuple2((Object)d.getIdentifier(), (Object)d);
        });
        JavaRDD entities = mapDocuments.map((Function & Serializable)d -> ((Field)((MapDocument)d._2()).getFieldMap().get("groundTruth")).stringValue());
        JavaRDD blocks = Deduper.createSortedBlocks((JavaPairRDD<String, MapDocument>)mapDocuments, dedupConfig).map((Function & Serializable)b -> ((Block)b._2()).getDocuments().stream().map(d -> ((Field)d.getFieldMap().get("groundTruth")).stringValue()).collect(Collectors.toList()));
        JavaRDD mergerels = this.spark.read().load(workingPath + "/mergerels").as(Encoders.bean(Relation.class)).toJavaRDD();
        JavaRDD simrels = this.spark.read().load(workingPath + "/simrels").as(Encoders.bean(Relation.class)).toJavaRDD();
        JavaRDD groups = sc.textFile(workingPath + "/groupentities").map((Function & Serializable)e -> (ConnectedComponent)new ObjectMapper().readValue(e, ConnectedComponent.class)).map((Function & Serializable)e -> e.getDocs().stream().map(d -> MapDocumentUtil.getJPathString((String)groundTruthFieldJPath, (String)d)).collect(Collectors.toList()));
        long entities_number = entities.count();
        long blocks_number = blocks.count();
        double blocks_randIndex = this.randIndex((JavaRDD<List<String>>)blocks);
        long simrels_number = simrels.count();
        long mergerels_number = mergerels.count();
        double groups_randIndex = this.randIndex((JavaRDD<List<String>>)groups);
        long groups_number = groups.count();
        long groundtruth_number = entities.filter((Function & Serializable)e -> !e.isEmpty()).count();
        long correct_groups = groups.filter((Function & Serializable)x -> x.stream().distinct().count() == 1L).count();
        long wrong_groups = groups_number - correct_groups;
        String print = "Entities : " + entities_number + "\nGround Truth : " + groundtruth_number + "\nBlocks : " + blocks_number + "\nBlocks RI : " + blocks_randIndex + "\nSimRels : " + simrels_number + "\nMergeRels : " + mergerels_number + "\nGroups : " + groups_number + " (correct: " + correct_groups + ", wrong: " + wrong_groups + ")\nGroups RI : " + groups_randIndex;
        System.out.println(print);
        SparkComputeStatistics.writeStatsFileToHDFS(groundtruth_number, entities_number, blocks_randIndex, groups_randIndex, blocks_number, simrels_number, mergerels_number, groups_number, workingPath + "/stats_file.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStatsFileToHDFS(long groundtruth_number, long entities_number, double blocks_randIndex, double groups_randIndex, long blocks_number, long simrels_number, long mergerels_number, long groups_number, String filePath) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(new Path(filePath), true);
        try {
            fs = FileSystem.get((Configuration)conf);
            Path outFile = new Path(filePath);
            if (fs.exists(outFile)) {
                System.out.println("Output file already exists");
                throw new IOException("Output file already exists");
            }
            String print = "Entities : " + entities_number + "\nGround Truth : " + groundtruth_number + "\nBlocks : " + blocks_number + "\nBlocks RI : " + blocks_randIndex + "\nSimRels : " + simrels_number + "\nMergeRels : " + mergerels_number + "\nGroups : " + groups_number + "\nGroups RI : " + groups_randIndex;
            try (FSDataOutputStream out = fs.create(outFile);){
                out.writeBytes(print);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double randIndex(JavaRDD<List<String>> clusters) {
        Tuple2 reduce = (Tuple2)clusters.map((Function & Serializable)c -> {
            int num = 0;
            for (String id : c.stream().distinct().filter(s -> !s.isEmpty()).collect(Collectors.toList())) {
                int n = (int)c.stream().filter(i -> i.equals(id)).count();
                num += SparkComputeStatistics.binomialCoefficient(n);
            }
            int den = SparkComputeStatistics.binomialCoefficient(c.size());
            return new Tuple2((Object)num, (Object)den);
        }).reduce((Function2 & Serializable)(a, b) -> new Tuple2((Object)((Integer)a._1() + (Integer)b._1()), (Object)((Integer)a._2() + (Integer)b._2())));
        return (double)((Integer)reduce._1()).intValue() / (double)((Integer)reduce._2()).intValue();
    }

    private static int binomialCoefficient(int n) {
        return n * (n - 1) / 2;
    }
}

