/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.jobs;

import eu.dnetlib.jobs.AbstractSparkJob;
import eu.dnetlib.jobs.SparkCreateSimRels;
import eu.dnetlib.support.ArgumentApplicationParser;
import eu.dnetlib.support.Relation;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkComputeStatistics
extends AbstractSparkJob {
    private static final Logger log = LoggerFactory.getLogger(SparkComputeStatistics.class);

    public SparkComputeStatistics(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(SparkComputeStatistics.readResource("/jobs/parameters/computeStatistics_parameters.json", SparkCreateSimRels.class));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkComputeStatistics(parser, SparkComputeStatistics.getSparkSession(conf)).run();
    }

    @Override
    public void run() throws IOException {
        String entitiesPath = this.parser.get("entitiesPath");
        String workingPath = this.parser.get("workingPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        log.info("entitiesPath:  '{}'", (Object)entitiesPath);
        log.info("workingPath:   '{}'", (Object)workingPath);
        log.info("numPartitions: '{}'", (Object)numPartitions);
        JavaRDD mergerels = this.spark.read().load(workingPath + "/mergerels").as(Encoders.bean(Relation.class)).toJavaRDD();
        JavaRDD simrels = this.spark.read().load(workingPath + "/simrels").as(Encoders.bean(Relation.class)).toJavaRDD();
        long simrels_number = simrels.count();
        long mergerels_number = mergerels.count();
        long connected_components = mergerels.groupBy(Relation::getSource).count();
        SparkComputeStatistics.writeStatsFileToHDFS(simrels_number, mergerels_number, connected_components, workingPath + "/stats_file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStatsFileToHDFS(long simrels_number, long mergerels_number, long connected_components, String filePath) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.delete(new Path(filePath), true);
        try {
            fs = FileSystem.get((Configuration)conf);
            Path outFile = new Path(filePath);
            if (fs.exists(outFile)) {
                System.out.println("Output file already exists");
                throw new IOException("Output file already exists");
            }
            String print = "Similarity Relations : " + simrels_number + "\nMerge Relations : " + mergerels_number + "\nConnected Components : " + connected_components;
            try (FSDataOutputStream out = fs.create(outFile);){
                out.writeBytes(print);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

