/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.jobs;

import eu.dnetlib.Deduper;
import eu.dnetlib.graph.GraphProcessor;
import eu.dnetlib.jobs.AbstractSparkJob;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.util.MapDocumentUtil;
import eu.dnetlib.pace.utils.Utility;
import eu.dnetlib.support.ArgumentApplicationParser;
import eu.dnetlib.support.Relation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.graphx.Edge;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkCreateMergeRels
extends AbstractSparkJob {
    private static final Logger log = LoggerFactory.getLogger(SparkCreateMergeRels.class);

    public SparkCreateMergeRels(ArgumentApplicationParser parser, SparkSession spark) {
        super(parser, spark);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(Utility.readResource("/jobs/parameters/createMergeRels_parameters.json", SparkCreateMergeRels.class));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        new SparkCreateMergeRels(parser, SparkCreateMergeRels.getSparkSession(conf)).run();
    }

    @Override
    public void run() throws IOException {
        String entitiesPath = this.parser.get("entitiesPath");
        String workingPath = this.parser.get("workingPath");
        String dedupConfPath = this.parser.get("dedupConfPath");
        int numPartitions = Optional.ofNullable(this.parser.get("numPartitions")).map(Integer::valueOf).orElse(1000);
        log.info("entitiesPath:  '{}'", (Object)entitiesPath);
        log.info("workingPath:   '{}'", (Object)workingPath);
        log.info("dedupConfPath: '{}'", (Object)dedupConfPath);
        log.info("numPartitions: '{}'", (Object)numPartitions);
        DedupConfig dedupConf = DedupConfig.load((String)SparkCreateMergeRels.readFileFromHDFS(dedupConfPath));
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)this.spark.sparkContext());
        JavaPairRDD vertexes = sc.textFile(entitiesPath).map((Function & Serializable)s -> MapDocumentUtil.getJPathString((String)dedupConf.getWf().getIdPath(), (String)s)).mapToPair((PairFunction & Serializable)s -> new Tuple2((Object)Deduper.hash(s), s));
        RDD edgeRdd = this.spark.read().load(workingPath + "/simrels").as(Encoders.bean(Relation.class)).javaRDD().map(Relation::toEdgeRdd).rdd();
        JavaRDD ccs = GraphProcessor.findCCs((RDD<Tuple2<Object, String>>)vertexes.rdd(), (RDD<Edge<String>>)edgeRdd, dedupConf.getWf().getMaxIterations()).toJavaRDD();
        JavaRDD mergeRel = ccs.filter((Function & Serializable)k -> k.getDocs().size() > 1).flatMap((FlatMapFunction & Serializable)cc -> Deduper.ccToMergeRel(cc, dedupConf)).map((Function & Serializable)it -> new Relation((String)it._1(), (String)it._2(), "mergeRel"));
        Dataset mergeRels = this.spark.createDataset(mergeRel.rdd(), Encoders.bean(Relation.class));
        mergeRels.write().mode(SaveMode.Overwrite).parquet(workingPath + "/mergerels");
    }
}

