/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.pace.util.PaceException;
import eu.dnetlib.pace.utils.Utility;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;

public class ConnectedComponent
implements Serializable {
    private HashSet<String> docs;
    private String ccId;

    public ConnectedComponent() {
    }

    public ConnectedComponent(Set<String> docs) {
        this.docs = new HashSet<String>(docs);
        this.createID();
    }

    public String createID() {
        if (this.docs.size() > 1) {
            String s = this.getMin();
            this.ccId = "dedup::" + Utility.md5(s);
            return this.ccId;
        }
        return this.docs.iterator().next();
    }

    @JsonIgnore
    public String getMin() {
        StringBuilder min = new StringBuilder();
        this.docs.forEach(i -> {
            if (StringUtils.isBlank((String)min.toString())) {
                min.append((String)i);
            } else if (min.toString().compareTo((String)i) > 0) {
                min.setLength(0);
                min.append((String)i);
            }
        });
        return min.toString();
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new PaceException("Failed to create Json: ", (Throwable)e);
        }
    }

    public Set<String> getDocs() {
        return this.docs;
    }

    public void setDocs(HashSet<String> docs) {
        this.docs = docs;
    }

    public String getCcId() {
        return this.ccId;
    }

    public void setCcId(String ccId) {
        this.ccId = ccId;
    }
}

