package eu.dnetlib.msro.workflows.dedup;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.proto.DedupSimilarityProtos.DedupSimilarity;
import eu.dnetlib.data.proto.RelTypeProtos.RelType;
import eu.dnetlib.data.proto.RelTypeProtos.SubRelType;
import eu.dnetlib.data.proto.TypeProtos.Type;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.rmi.MSROException;

public class DedupSimilarityToActionsJobNode extends DedupConfigurationAwareJobNode {

	private static final Log log = LogFactory.getLog(DedupSimilarityToActionsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		super.prepareJob(job, token);

		final String entityType = token.getEnv().getAttribute("entityType");
		if (StringUtils.isBlank(entityType))
			throw new MSROException("unable to find wf param: entityType");

		String cf = "_" + SubRelType.dedupSimilarity + "_" + DedupSimilarity.RelName.isSimilarTo;
		switch (Type.valueOf(entityType)) {

		case organization:
			cf = RelType.organizationOrganization + cf;
			break;
		case person:
			cf = RelType.personPerson + cf;
			break;
		case result:
			cf = RelType.resultResult + cf;
			break;
		default:
			throw new MSROException("invalid parameter entityType: " + entityType);
		}

		log.info("using similarity CF: " + cf);
		job.getParameters().put("similarityCF", cf);
		token.getEnv().setAttribute("similarityCF", cf);
	}

}
