package eu.dnetlib.msro.workflows.hadoop.hbase;

import java.util.Set;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.hadoop.rmi.HadoopService;
import eu.dnetlib.msro.rmi.MSROException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateHBaseTableJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(CreateHBaseTableJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private boolean reuseRegionInfo = false;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final Set<String> columns = getColumns(token);
		final String tableName = tableName(token);
		final String cluster = cluster(token);

		log.info("Ensuring table " + tableName + " on cluster: '" + cluster + "' - columns: " + columns);

		if (isReuseRegionInfo()) {
			String jsonConf = token.getEnv().getAttribute(getTableConfigurationParamName());
			if (StringUtils.isBlank(jsonConf)) {
				throw new MSROException("cannot find HBase table configuration in workflow env");
			}

			getServiceLocator().getService(HadoopService.class).createConfiguredHbaseTable(cluster, tableName, jsonConf);
		} else {
			getServiceLocator().getService(HadoopService.class).createHbaseTable(cluster, tableName, columns);
		}
		return Arc.DEFAULT_ARC;
	}

	public boolean isReuseRegionInfo() {
		return reuseRegionInfo;
	}

	public void setReuseRegionInfo(final boolean reuseRegionInfo) {
		this.reuseRegionInfo = reuseRegionInfo;
	}
}
