/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.dedup;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.data.dedup.OafResult;
import eu.dnetlib.data.mapreduce.util.OafDecoder;
import eu.dnetlib.data.mapreduce.util.OafEntityDecoder;
import eu.dnetlib.data.proto.OafProtos;
import eu.dnetlib.data.transform.OafEntityMerger;
import eu.dnetlib.data.transform.SolrProtoMapper;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.index.client.IndexClient;
import eu.dnetlib.functionality.index.client.IndexClientException;
import eu.dnetlib.functionality.index.client.ResolvingIndexClientFactory;
import eu.dnetlib.functionality.index.client.response.LookupResponse;
import eu.dnetlib.functionality.modular.ui.dedup.SimilarityGroup;
import eu.dnetlib.pace.config.DedupConfig;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.common.SolrInputDocument;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DedupIndexDAO {
    private static final Log log = LogFactory.getLog(DedupIndexDAO.class);
    private static final String ID_PREFIX_REGEX = "^\\d\\d\\|";
    private static final Map<String, Map<String, String>> paths = Maps.newHashMap();
    @Resource
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ResolvingIndexClientFactory indexClientFactory;
    private IndexClient indexClient = null;
    @Value(value="${dnet.dedup.index.format}")
    private String indexFormat;
    @Value(value="${dnet.dedup.index.collection}")
    private String dedupIndexCollection;

    public OafResult search(String type, String userQuery, String actionSet, int start, int rows, String fields) throws Exception {
        String cqlQuery = String.format("(>s=SOLR s.q.op=AND) and oaftype = %s and actionset exact \"%s\" and deletedbyinference = false and %s", type, actionSet, userQuery);
        LookupResponse rsp = this.getIndexClient().lookup(cqlQuery, null, start, start + rows - 1);
        LinkedList fieldList = Lists.newLinkedList((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)fields));
        LinkedList resList = Lists.newLinkedList((Iterable)Iterables.transform(this.toOaf(rsp), this.getOaf2FieldMapFunction(type, fieldList)));
        return new OafResult(rsp.getTotal(), resList);
    }

    public OafResult searchById(String actionSet, String type, String objidentifier, List<String> fields) throws Exception {
        String cqlQuery = "objidentifier exact \"" + objidentifier + "\" and actionset exact \"" + actionSet + "\"";
        LookupResponse rsp = this.getIndexClient().lookup(cqlQuery, null, 0, 1);
        Iterable<OafProtos.Oaf> oafList = this.toOaf(rsp);
        LinkedList resList = Lists.newLinkedList((Iterable)Iterables.transform(oafList, this.getOaf2FieldMapFunction(type, fields)));
        return new OafResult(rsp.getTotal(), resList);
    }

    public boolean commit(SimilarityGroup group) throws Exception {
        int commitStatus = 0;
        int addStatus = 0;
        log.info((Object)"starting index update");
        try (CloudSolrClient solrServer = this.getSolrServer();){
            SolrProtoMapper mapper = this.initProtoMapper();
            Function<OafProtos.Oaf, SolrInputDocument> oaf2solr = this.oaf2solr(group, mapper);
            LinkedList buffer = Lists.newLinkedList();
            List<OafProtos.Oaf> groupDocs = this.markDeleted(this.asOafBuilder(this.parseBase64(this.queryIndex(group.getGroup(), group.getActionSet()))));
            buffer.addAll(this.asIndexDocs(oaf2solr, groupDocs));
            SolrInputDocument newRoot = (SolrInputDocument)oaf2solr.apply((Object)OafEntityMerger.merge((DedupConfig)this.getDedupConf(group), (String)this.newRootId(group), groupDocs).build());
            String newRootId = (String)newRoot.getFieldValue("objidentifier");
            buffer.add(newRoot);
            List<OafProtos.Oaf> dissimDocs = this.markUnDeleted(this.asOafBuilder(this.parseBase64(this.queryIndex(this.unique(group.getDissimilar()), group.getActionSet()))));
            buffer.addAll(this.asIndexDocs(oaf2solr, dissimDocs));
            log.debug((Object)String.format("adding %d documents to index %s", buffer.size(), this.dedupIndexCollection));
            addStatus = solrServer.add((Collection)buffer).getStatus();
            log.debug((Object)("solr add status: " + addStatus));
            log.debug((Object)String.format("deleting %d documents from index %s", group.getRootIds().size(), this.dedupIndexCollection));
            for (String rootId2 : Iterables.filter(group.getRootIds(), rootId -> !rootId.equals(newRootId))) {
                solrServer.deleteById(mapper.getRecordId(rootId2, group.getActionSet()));
            }
            commitStatus = solrServer.commit().getStatus();
            log.debug((Object)("solr commit status: " + commitStatus));
        }
        return addStatus == 0 && commitStatus == 0;
    }

    private Iterable<OafProtos.Oaf> toOaf(LookupResponse rsp) {
        return Iterables.transform((Iterable)rsp.getRecords(), this.getXml2OafFunction());
    }

    private Iterable<OafProtos.Oaf> parseBase64(Iterable<String> r) {
        return Iterables.transform(r, this.getXml2OafFunction());
    }

    private Function<String, OafProtos.Oaf> getXml2OafFunction() {
        return s -> {
            String base64 = StringUtils.substringBefore((String)StringUtils.substringAfter((String)s, (String)">"), (String)"<");
            try {
                byte[] oafBytes = Base64.decodeBase64((String)base64);
                OafProtos.Oaf oaf = OafDecoder.decode((byte[])oafBytes).getOaf();
                return oaf;
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("unable to decode base64 encoded Oaf object: " + base64);
            }
        };
    }

    private SolrProtoMapper initProtoMapper() throws DocumentException, ISLookUpException, ISLookUpDocumentNotFoundException {
        return new SolrProtoMapper(((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='" + this.indexFormat + "']//LAYOUT[@name='index']/FIELDS"));
    }

    private CloudSolrClient getSolrServer() {
        String zk = this.getIndexSolrUrlZk();
        log.info((Object)String.format("initializing solr client for collection %s, zk url: %s", this.dedupIndexCollection, zk));
        CloudSolrClient solrServer = new CloudSolrClient.Builder().withZkHost(zk).build();
        solrServer.setDefaultCollection(this.dedupIndexCollection);
        return solrServer;
    }

    private String getIndexSolrUrlZk() {
        try {
            return this.getResourceProfileByQuery("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//PROTOCOL[./@name='solr']/@address/string()");
        }
        catch (ISLookUpException e) {
            throw new IllegalStateException("unable to read solr ZK url from service profile", e);
        }
    }

    private String getResourceProfileByQuery(String xquery) throws ISLookUpException {
        log.debug((Object)("quering for service property: " + xquery));
        String res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
        if (StringUtils.isBlank((String)res)) {
            throw new IllegalStateException("unable to find unique service property, xquery: " + xquery);
        }
        return res;
    }

    private Function<OafProtos.Oaf, Map<String, String>> getOaf2FieldMapFunction(String type, List<String> fields) {
        return oaf -> {
            OafEntityDecoder ed = OafDecoder.decode((OafProtos.Oaf)oaf).decodeEntity();
            HashMap res = Maps.newHashMap();
            String oafId = this.cleanId(oaf.getEntity().getId());
            List idList = oaf.getEntity().getChildrenList().stream().map(e -> e.getId()).map(s -> this.cleanId((String)s)).collect(Collectors.toList());
            if (idList.isEmpty()) {
                idList.add(oafId);
            }
            res.put("id", oafId);
            res.put("idList", Joiner.on((String)",").join(idList));
            res.put("groupSize", idList.isEmpty() ? "1" : idList.size() + "");
            for (String fieldName : fields) {
                res.put(fieldName, Joiner.on((String)"; ").skipNulls().join((Iterable)ed.getFieldValues(paths.get(type).get(fieldName))));
            }
            return res;
        };
    }

    private String cleanId(String id) {
        return id.replaceFirst(ID_PREFIX_REGEX, "");
    }

    private IndexClient getIndexClient() throws IndexClientException, ISLookUpDocumentNotFoundException, ISLookUpException {
        if (this.indexClient == null) {
            this.indexClient = this.indexClientFactory.getClient(this.indexFormat, "index", "dedup", "solr");
        }
        return this.indexClient;
    }

    private Iterable<String> queryIndex(Iterable<String> ids, String actionset) {
        return Iterables.transform(ids, id -> {
            try {
                String cql = "objidentifier exact \"" + id + "\" and actionset exact \"" + actionset + "\"";
                LookupResponse rsp = this.getIndexClient().lookup(cql, null, 0, 1);
                log.debug((Object)String.format("query index for id '%s', found '%d'", id, rsp.getTotal()));
                return (String)Iterables.getOnlyElement((Iterable)rsp.getRecords());
            }
            catch (Throwable e) {
                log.error((Object)e);
                throw new RuntimeException("unable to query id: " + id, e);
            }
        });
    }

    private List<OafProtos.Oaf> markDeleted(Iterable<OafProtos.Oaf.Builder> builders) {
        return Lists.newArrayList((Iterable)Iterables.transform(builders, builder -> {
            builder.getDataInfoBuilder().setDeletedbyinference(true);
            return builder.build();
        }));
    }

    private List<OafProtos.Oaf> markUnDeleted(Iterable<OafProtos.Oaf.Builder> builders) {
        return Lists.newArrayList((Iterable)Iterables.transform(builders, builder -> {
            builder.getDataInfoBuilder().setDeletedbyinference(false);
            return builder.build();
        }));
    }

    private Iterable<OafProtos.Oaf.Builder> asOafBuilder(Iterable<OafProtos.Oaf> oaf) {
        return Iterables.transform(oaf, oaf1 -> OafProtos.Oaf.newBuilder((OafProtos.Oaf)oaf1));
    }

    private String newRootId(SimilarityGroup group) {
        return "dedup_wf_001::" + Collections.min(group.getGroup()).replaceFirst("^.*::", "");
    }

    private List<SolrInputDocument> asIndexDocs(Function<OafProtos.Oaf, SolrInputDocument> mapper, Iterable<OafProtos.Oaf> protos) {
        return Lists.newArrayList((Iterable)Iterables.transform(protos, mapper));
    }

    private Function<OafProtos.Oaf, SolrInputDocument> oaf2solr(SimilarityGroup group, SolrProtoMapper mapper) {
        return oaf -> {
            try {
                return mapper.map((GeneratedMessage)oaf, group.getDate(), "", group.getActionSet());
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("unable to map proto to index document", e);
            }
        };
    }

    private Set<String> unique(Map<String, Set<String>> map) {
        HashSet res = Sets.newHashSet();
        for (Set<String> ids : map.values()) {
            res.addAll(ids);
        }
        return res;
    }

    private DedupConfig getDedupConf(SimilarityGroup group) throws IOException {
        HashMap config = Maps.newHashMap();
        config.put("entityType", group.getEntityType().getType());
        config.put("configurationId", group.getActionSet());
        DedupConfig dedupConf = DedupConfig.loadDefault((Map)config);
        return dedupConf;
    }

    static {
        paths.put("result", new HashMap());
        paths.put("organization", new HashMap());
        paths.put("person", new HashMap());
        paths.get("result").put("provenance", "collectedfrom/value");
        paths.get("organization").put("provenance", "collectedfrom/value");
        paths.get("person").put("provenance", "collectedfrom/value");
        paths.get("result").put("title", "result/metadata/title/value");
        paths.get("result").put("dateofacceptance", "result/metadata/dateofacceptance/value");
        paths.get("result").put("description", "result/metadata/description/value");
        paths.get("result").put("author", "result/author/metadata/fullname/value");
        paths.get("organization").put("legalname", "organization/metadata/legalname/value");
        paths.get("organization").put("legalshortname", "organization/metadata/legalshortname/value");
        paths.get("organization").put("websiteurl", "organization/metadata/websiteurl/value");
        paths.get("organization").put("country", "organization/metadata/country/classid");
        paths.get("person").put("fullname", "person/metadata/fullname/value");
    }
}

