/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.actionmanager.set.RawSet;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareConfiguredActionSetJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareConfiguredActionSetJobNode.class);
    private String dedupConfigSequenceParam;
    private String jobProperty;
    private String actionSetPathParam;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    protected String execute(NodeToken token) throws Exception {
        ArrayList setList = Lists.newArrayList();
        HashMap set = Maps.newHashMap();
        String actionSetId = this.getActionSetId(token);
        ISLookUpService isLookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String basePath = isLookUpService.getResourceProfileByQuery("/RESOURCE_PROFILE[./HEADER/RESOURCE_TYPE/@value='ActionManagerServiceResourceType']//SERVICE_PROPERTIES/PROPERTY[@key='basePath']/@value/string()");
        if (StringUtils.isBlank((String)basePath)) {
            throw new IllegalStateException("missing basePath in ActionManagerService");
        }
        String actionSetDirectory = isLookUpService.getResourceProfileByQuery("/RESOURCE_PROFILE[./HEADER/RESOURCE_TYPE/@value='ActionManagerSetDSResourceType' and .//SET/@id = '" + actionSetId + "']//SET/@ directory/string()");
        if (StringUtils.isBlank((String)actionSetDirectory)) {
            throw new IllegalStateException("missing directory in ActionSet profile: " + actionSetId);
        }
        String rawSetId = RawSet.newInstance().getId();
        set.put("rawset", rawSetId);
        set.put("creationDate", DateUtils.now_ISO8601());
        set.put("set", actionSetId);
        set.put("enabled", "true");
        set.put("jobProperty", this.getJobProperty());
        token.getEnv().setAttribute((String)set.get("jobProperty"), (String)set.get("rawset"));
        String path = basePath + "/" + actionSetDirectory + "/" + rawSetId;
        log.info((Object)("using action set path: " + path));
        token.getEnv().setAttribute(this.getActionSetPathParam(), path);
        setList.add(set);
        String sets = new Gson().toJson((Object)setList);
        log.debug((Object)("built set: " + sets));
        token.getEnv().setAttribute("sets", sets);
        return Arc.DEFAULT_ARC;
    }

    private String getActionSetId(NodeToken token) {
        String json = token.getEnv().getAttribute(this.getDedupConfigSequenceParam());
        DedupConfigurationOrchestration dco = DedupConfigurationOrchestration.fromJSON(json);
        String actionSetId = dco.getActionSetId();
        log.info((Object)("found actionSetId in workflow env: " + actionSetId));
        return actionSetId;
    }

    public String getDedupConfigSequenceParam() {
        return this.dedupConfigSequenceParam;
    }

    public void setDedupConfigSequenceParam(String dedupConfigSequenceParam) {
        this.dedupConfigSequenceParam = dedupConfigSequenceParam;
    }

    public String getJobProperty() {
        return this.jobProperty;
    }

    public void setJobProperty(String jobProperty) {
        this.jobProperty = jobProperty;
    }

    public String getActionSetPathParam() {
        return this.actionSetPathParam;
    }

    public void setActionSetPathParam(String actionSetPathParam) {
        this.actionSetPathParam = actionSetPathParam;
    }
}

