package eu.dnetlib.msro.workflows.dedup;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;

public class DedupDuplicateScanJobNode extends DedupConfigurationAwareJobNode {

	private static final Log log = LogFactory.getLog(DedupDuplicateScanJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private class DedupBlackboardWorkflowJobListener extends BlackboardWorkflowJobListener {

		public DedupBlackboardWorkflowJobListener(final Engine engine, final NodeToken token) {
			super(engine, token);
		}

		@Override
		protected void onDone(final BlackboardJob job) {

			final DedupConfigurationOrchestration confs = dedupConfigurations(getToken());

			confs.getConfigurations().poll();

			log.info("checking dedup configs queue, size: " + confs.getConfigurations().size());

			if (CollectionUtils.isEmpty(confs.getConfigurations())) {
				log.info("dedup similarity scan done");
				super.complete(job, "done");
			} else {
				log.debug("remaining confs: " + confs);

				getToken().getEnv().setAttribute(getDedupConfigSequenceParam(), confs.toString());

				super.complete(job, Arc.DEFAULT_ARC);
			}
		}
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Engine engine, final NodeToken token) {
		return new DedupBlackboardWorkflowJobListener(engine, token);
	}

}
