package eu.dnetlib.msro.workflows.hadoop;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;

public class IndexDSUpdateJobNode extends AsyncJobNode {

	private static final Log log = LogFactory.getLog(IndexDSUpdateJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	public String execute(final NodeToken token) throws Exception {

		final String dsId = token.getEnv().getAttribute("index_id");
		final String version = token.getEnv().getAttribute("index.feed.timestamp");
		log.info("updating indexDS: " + dsId + " version: " + version);
		updateIndexDS(dsId, version);

		return Arc.DEFAULT_ARC;
	}

	/**
	 * method updates the given indexDataStructureId INDEX_SIZE, INDEX_LAST_UPDATE
	 * 
	 * @param dsId
	 * @param version
	 * @return true if the update was performed successfully, false otherwise
	 * @throws ISRegistryException
	 */
	private boolean updateIndexDS(final String dsId, final String version) throws ISRegistryException {

		final String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']"
				+ " return update value $x//INDEX_LAST_UPDATE with '" + version + "'";

		log.debug("\n\n updating indexDataStructure: " + xquery + "\n\n");

		return serviceLocator.getService(ISRegistryService.class).executeXUpdate(xquery);
	}

}
