package eu.dnetlib.msro.workflows.dedup;

import static java.lang.String.format;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.data.provision.index.rmi.IndexService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.functionality.index.solr.feed.InputDocumentFactory;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;

public class FinalizeDedupIndexJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(FinalizeDedupIndexJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected String obtainServiceId(final NodeToken token) {
		return getServiceLocator().getServiceId(IndexService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final NodeToken token) throws Exception {
		final String indexDsId = getEnvParam(token, "index_id");

		log.info("preparing blackboard job DELETE_BY_QUERY index: " + indexDsId);

		final String backendId = getBackendId(indexDsId);
		if (StringUtils.isBlank(backendId))
			throw new MSROException("empty index backend Id");

		job.setAction("DELETE_BY_QUERY");
		job.getParameters().put("id", indexDsId);
		job.getParameters().put("backend_Id", backendId);
		job.getParameters().put("query",
				buildQuery(getEnvParam(token, "entityType"), getEnvParam(token, "index.feed.timestamp"), getEnvParam(token, "actionset")));
	}

	private String buildQuery(final String entityType, final String version, final String actionset) {
		final String query =
				String.format("__dsversion:{* TO %s} AND oaftype:%s AND actionset:%s", InputDocumentFactory.getParsedDateField(version), entityType, actionset);

		log.info("delete by query: " + query);

		return query;
	}

	private String getEnvParam(final NodeToken token, final String name) throws MSROException {
		final String value = token.getEnv().getAttribute(name);

		if (StringUtils.isBlank(value))
			throw new MSROException(format("unable to finalize index feeding, cannot find property '%s' in the workflow env.", name));

		return value;
	}

	public String getBackendId(final String indexDsId) throws ISLookUpDocumentNotFoundException, ISLookUpException {
		return getServiceLocator().getService(ISLookUpService.class).getResourceProfileByQuery(
				"//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + indexDsId + "']//BACKEND/text()");
	}

}
