package eu.dnetlib.msro.workflows.dedup.conf;

import java.util.Queue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import eu.dnetlib.pace.config.DedupConfig;

/**
 * The Class DedupConfigurationOrchestration.
 */
public class DedupConfigurationOrchestration {

	/** The entity. */
	private Entity entity;

	/** The action set id. */
	private String actionSetId;

	/** The configurations. */
	private Queue<DedupConfig> configurations;

	public DedupConfigurationOrchestration() {}

	/**
	 * Instantiates a new dedup configuration orchestration.
	 *
	 * @param entity
	 *            the entity
	 * @param actionSetId
	 *            the action set id
	 * @param configurations
	 *            the configurations
	 */
	public DedupConfigurationOrchestration(final Entity entity, final String actionSetId, final Queue<DedupConfig> configurations) {
		super();
		this.setEntity(entity);
		this.setActionSetId(actionSetId);
		this.setConfigurations(configurations);
	}

	/**
	 * Gets the entity.
	 *
	 * @return the entity
	 */
	public Entity getEntity() {
		return entity;
	}

	/**
	 * Gets the action set id.
	 *
	 * @return the action set id
	 */
	public String getActionSetId() {
		return actionSetId;
	}

	/**
	 * Gets the configurations.
	 *
	 * @return the configurations
	 */
	public Queue<DedupConfig> getConfigurations() {
		return configurations;
	}

	public void setEntity(final Entity entity) {
		this.entity = entity;
	}

	public void setActionSetId(final String actionSetId) {
		this.actionSetId = actionSetId;
	}

	public void setConfigurations(final Queue<DedupConfig> configurations) {
		this.configurations = configurations;
	}

	/**
	 * From json.
	 *
	 * @param json
	 *            the json
	 * @return the dedup configuration orchestration
	 */
	public static DedupConfigurationOrchestration fromJSON(final String json) {
		return new Gson().fromJson(json, DedupConfigurationOrchestration.class);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return new GsonBuilder().setPrettyPrinting().create().toJson(this);
	}

}
