package eu.dnetlib.msro.workflows.hadoop.hbase;

import java.util.Set;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.openaire.hadoop.utils.HBaseTableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefineHBaseOpenaireSchemaJobNode extends AbstractHBaseAdminJobNode {

	private static final Log log = LogFactory.getLog(DefineHBaseOpenaireSchemaJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String schema;

	@Override
	protected String execute(final NodeToken token) throws Exception {

		final String schemaOverride = StringUtils.isNotBlank(getSchema()) ? getSchema() : asCSV(HBaseTableUtils.listAllColumns());
		log.info("table definition: " + schemaOverride);
		token.getEnv().setAttribute(getTableColumnsParamName(), schemaOverride);

		return Arc.DEFAULT_ARC;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(final String schema) {
		this.schema = schema;
	}
}
