package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;
import org.springframework.beans.factory.annotation.Required;

public class ListHBaseMappingTitleValues extends ValidNodeValuesFetcher {

	@Resource
	private UniqueServiceLocator serviceLocator;

	private String sourceFormat;

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {

		final String xquery =
				"for $x in /RESOURCE_PROFILE["
						+ ".//RESOURCE_TYPE/@value='TransformationRuleDSResourceType' and "
						+ ".//SOURCE_METADATA_FORMAT/@name = '" + getSourceFormat() + "' and "
						+ ".//SOURCE_METADATA_FORMAT/@layout = 'store' and "
						+ ".//SOURCE_METADATA_FORMAT/@interpretation = 'cleaned'] "
						+ "return concat($x//RESOURCE_IDENTIFIER/@value, ' @@@ ', $x//SCRIPT/TITLE/text())";

		final List<String> result = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);
		final List<DnetParamValue> values = Lists.newArrayList();

		for (final String s : result) {
			final String[] arr = s.split("@@@");
			values.add(new DnetParamValue(arr[0].trim(), arr[1].trim()));
		}

		return values;
	}

	public String getSourceFormat() {
		return sourceFormat;
	}

	@Required
	public void setSourceFormat(final String sourceFormat) {
		this.sourceFormat = sourceFormat;
	}

}
