/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CheckDoneJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(CheckDoneJobNode.class);
    private String param;
    private String exitArc;

    protected String execute(NodeToken token) throws Exception {
        if (StringUtils.isBlank((String)this.getParam())) {
            throw new MSROException("cannot find param name, please set it on the workflow definition");
        }
        String simRels = token.getFullEnv().getAttribute(this.getParam());
        if (StringUtils.isBlank((String)simRels)) {
            throw new MSROException(String.format("cannot find param '%s' in workflow env", this.getParam()));
        }
        if (Integer.parseInt(simRels) > 0) {
            log.info((Object)String.format("found %s %s, continue with the next iteration", simRels, this.getParam()));
            return this.getExitArc();
        }
        log.info((Object)String.format("found %s %s, done", simRels, this.getParam()));
        return Arc.DEFAULT_ARC;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getExitArc() {
        return this.exitArc;
    }

    public void setExitArc(String exitArc) {
        this.exitArc = exitArc;
    }
}

