/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.google.common.base.Splitter;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResetCountersJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(ResetCountersJobNode.class);
    private String attributesCSV;

    protected String execute(NodeToken token) throws Exception {
        if (StringUtils.isNotBlank((String)this.getAttributesCSV())) {
            log.info((Object)("got wf attributes CSV: " + this.getAttributesCSV()));
            Splitter splitter = Splitter.on((String)",").trimResults().omitEmptyStrings();
            List wfAttrs = splitter.splitToList((CharSequence)this.getAttributesCSV());
            for (String attr : wfAttrs) {
                this.resetWorkflowParam(token, attr);
            }
        } else {
            log.info((Object)"attribute list is empty, nothing to do here.");
        }
        return Arc.DEFAULT_ARC;
    }

    private void resetWorkflowParam(NodeToken token, String attribute) {
        String count = token.getFullEnv().getAttribute(attribute);
        if (StringUtils.isNotBlank((String)count)) {
            log.info((Object)String.format("found loop counter '%s', value '%s'", attribute, count));
            token.getFullEnv().setAttribute(attribute, (Object)0);
            log.info((Object)String.format("set '%s', to 0", attribute));
        } else {
            log.info((Object)"loop counter was not found in workflow env, nothing to do here.");
        }
    }

    public String getAttributesCSV() {
        return this.attributesCSV;
    }

    public void setAttributesCSV(String attributesCSV) {
        this.attributesCSV = attributesCSV;
    }
}

