package eu.dnetlib.functionality.modular.ui.dedup;

import java.util.Map;
import java.util.Set;

/**
 * SimilarityGroup models the user actions upon the commit.
 */
public class SimilarityGroup {

	/** The id. */
	private String id;

	/** The date. */
	private String date;

	/** The entity type. */
	private EntityType entityType;

	/** The action set. */
	private String actionSet;

	/** The group. */
	private Set<String> group;

	/** The root ids. */
	private Set<String> rootIds;

	/** The dissimilar. */
	private Map<String, Set<String>> dissimilar;

	/**
	 * Instantiates a new similarity group.
	 */
	public SimilarityGroup() {}

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id
	 *            the new id
	 */
	public void setId(final String id) {
		this.id = id;
	}

	/**
	 * Gets the date.
	 *
	 * @return the date
	 */
	public String getDate() {
		return date;
	}

	/**
	 * Sets the date.
	 *
	 * @param date
	 *            the new date
	 */
	public void setDate(final String date) {
		this.date = date;
	}

	/**
	 * Gets the group.
	 *
	 * @return the group
	 */
	public Set<String> getGroup() {
		return group;
	}

	/**
	 * Sets the group.
	 *
	 * @param group
	 *            the new group
	 */
	public void setGroup(final Set<String> group) {
		this.group = group;
	}

	/**
	 * Gets the entity type.
	 *
	 * @return the entity type
	 */
	public EntityType getEntityType() {
		return entityType;
	}

	/**
	 * Sets the entity type.
	 *
	 * @param entityType
	 *            the new entity type
	 */
	public void setEntityType(final EntityType entityType) {
		this.entityType = entityType;
	}

	/**
	 * Gets the root ids.
	 *
	 * @return the root ids
	 */
	public Set<String> getRootIds() {
		return rootIds;
	}

	/**
	 * Sets the root ids.
	 *
	 * @param rootIds
	 *            the new root ids
	 */
	public void setRootIds(final Set<String> rootIds) {
		this.rootIds = rootIds;
	}

	/**
	 * Gets the dissimilar.
	 *
	 * @return the dissimilar
	 */
	public Map<String, Set<String>> getDissimilar() {
		return dissimilar;
	}

	/**
	 * Sets the dissimilar.
	 *
	 * @param dissimilar
	 *            the dissimilar
	 */
	public void setDissimilar(final Map<String, Set<String>> dissimilar) {
		this.dissimilar = dissimilar;
	}

	/**
	 * Gets the action set.
	 *
	 * @return the action set
	 */
	public String getActionSet() {
		return actionSet;
	}

	/**
	 * Sets the action set.
	 *
	 * @param actionSet
	 *            the new action set
	 */
	public void setActionSet(final String actionSet) {
		this.actionSet = actionSet;
	}

}
