package eu.dnetlib.functionality.modular.ui.workflows.values;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.google.common.collect.Lists;

import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.util.ValidNodeValuesFetcher;

public class ListDedupOrchestrationValues extends ValidNodeValuesFetcher {

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected List<DnetParamValue> obtainValues(final Map<String, String> params) throws Exception {

		final String xquery =
				"for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='DedupOrchestrationDSResourceType'] return $x//ACTION_SET/@id/string()";

		final List<String> result = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);
		final List<DnetParamValue> values = Lists.newArrayList();

		for (final String s : result) {
			values.add(new DnetParamValue(s, s));
		}

		return values;
	}

}
