/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DedupCheckConfigurationJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(DedupCheckConfigurationJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String dedupConfigSequenceParam;

    protected String execute(NodeToken token) throws Exception {
        String dcoJson = token.getEnv().getAttribute(this.getDedupConfigSequenceParam());
        DedupConfigurationOrchestration dco = DedupConfigurationOrchestration.fromJSON(dcoJson);
        if (!this.existActionSetProfile(dco)) {
            throw new MSROException("missing action set profile: " + dco.getActionSetId());
        }
        log.info((Object)("found action set profile: " + dco.getActionSetId()));
        return Arc.DEFAULT_ARC;
    }

    private boolean existActionSetProfile(DedupConfigurationOrchestration dco) throws ISLookUpException {
        String xquery = "for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType' and .//ACTION_SET/@id='%s'] return 1";
        log.info((Object)("looking for action set profile, id: " + dco.getActionSetId()));
        List actionSets = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(String.format("for $x in //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'DedupOrchestrationDSResourceType' and .//ACTION_SET/@id='%s'] return 1", dco.getActionSetId()));
        return !actionSets.isEmpty();
    }

    public String getDedupConfigSequenceParam() {
        return this.dedupConfigSequenceParam;
    }

    public void setDedupConfigSequenceParam(String dedupConfigSequenceParam) {
        this.dedupConfigSequenceParam = dedupConfigSequenceParam;
    }
}

