/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.dedup;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.dedup.conf.DedupConfigurationOrchestrationLoader;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DedupCheckEntitySequenceJobNode
extends AsyncJobNode {
    private static final Log log = LogFactory.getLog(DedupCheckEntitySequenceJobNode.class);
    @Autowired
    private DedupConfigurationOrchestrationLoader dedupOrchestrationLoader;
    private String dedupConfigSequenceParam;
    private String entitySequence;

    protected String execute(NodeToken token) throws Exception {
        if (StringUtils.isBlank((String)this.getEntitySequence())) {
            throw new MSROException("missing entity sequence, e.g. a csv: organization,person,result");
        }
        if (token.getFullEnv().hasAttribute("dedup.grouper.looper")) {
            log.info((Object)"reset env variable: dedup.grouper.looper to zero");
            token.getFullEnv().setAttribute("dedup.grouper.looper", (Object)0);
        }
        if (!token.getEnv().hasAttribute("entitySequence")) {
            log.info((Object)("parsing config sequence: " + this.getEntitySequence()));
            token.getEnv().setAttribute("entitySequence", this.getEntitySequence());
            Iterable sequence = Splitter.on((String)",").omitEmptyStrings().split((CharSequence)this.getEntitySequence());
            LinkedList q = Lists.newLinkedList((Iterable)Iterables.transform((Iterable)sequence, (Function)new Function<String, DedupConfigurationOrchestration>(){

                public DedupConfigurationOrchestration apply(String entityName) {
                    try {
                        DedupConfigurationOrchestration dco = (DedupConfigurationOrchestration)Iterables.getFirst(DedupCheckEntitySequenceJobNode.this.dedupOrchestrationLoader.loadByEntityName(entityName), null);
                        if (dco == null) {
                            throw new RuntimeException("unable to find DedupOrchestration profile for entity type: " + entityName);
                        }
                        return dco;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException("", e);
                    }
                }
            }));
            log.info((Object)("built sequence of dedup orchestration profiles, size: " + q.size()));
            DedupConfigurationOrchestration dco = (DedupConfigurationOrchestration)q.remove();
            log.info((Object)("closing mesh for entity: " + dco.getEntity().getName()));
            this.setDedupConfParams(token, dco);
            token.getEnv().setTransientAttribute("entitySequenceQueue", (Object)q);
            return Arc.DEFAULT_ARC;
        }
        Queue q = (Queue)token.getEnv().getTransientAttribute("entitySequenceQueue");
        if (!q.isEmpty()) {
            log.info((Object)("remaining dedup orchestration profiles: " + q.size()));
            DedupConfigurationOrchestration dco = (DedupConfigurationOrchestration)q.remove();
            log.info((Object)("closing mesh for entity: " + dco.getEntity().getName()));
            this.setDedupConfParams(token, dco);
            return Arc.DEFAULT_ARC;
        }
        log.info((Object)("completed closing mesh for entities: " + this.getEntitySequence()));
        return "done";
    }

    private void setDedupConfParams(NodeToken token, DedupConfigurationOrchestration dco) {
        token.getEnv().setAttribute("entityType", dco.getEntity().getName());
        token.getEnv().setAttribute("entityTypeId", dco.getEntity().getCode());
        token.getEnv().setAttribute(this.getDedupConfigSequenceParam(), dco.toString());
    }

    public String getEntitySequence() {
        return this.entitySequence;
    }

    public void setEntitySequence(String entitySequence) {
        this.entitySequence = entitySequence;
    }

    public String getDedupConfigSequenceParam() {
        return this.dedupConfigSequenceParam;
    }

    public void setDedupConfigSequenceParam(String dedupConfigSequenceParam) {
        this.dedupConfigSequenceParam = dedupConfigSequenceParam;
    }
}

