/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.hadoop.hbase;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.rmi.MSROException;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHBaseAdminJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(AbstractHBaseAdminJobNode.class);
    private String tableColumnsParamName = "columns";
    private String tableConfigurationParamName = "tableConf";
    private String hbaseTableProperty;
    private String cluster;
    @Resource
    private UniqueServiceLocator serviceLocator;

    protected void beforeStart(NodeToken token) {
        for (Map.Entry e : this.parseJsonParameters(token).entrySet()) {
            token.getEnv().setAttribute((String)e.getKey(), (String)e.getValue());
        }
    }

    protected String tableName(NodeToken token) {
        if (token.getEnv().hasAttribute("hbaseTable")) {
            String table = token.getEnv().getAttribute("hbaseTable");
            log.debug((Object)("found override value in wfEnv for 'hbaseTable' param: " + table));
            return table;
        }
        return this.getPropertyFetcher().getProperty(this.getHbaseTableProperty());
    }

    protected String cluster(NodeToken token) {
        if (token.getEnv().hasAttribute("cluster")) {
            String cluster = token.getEnv().getAttribute("cluster");
            log.debug((Object)("found override value in wfEnv for 'cluster' param: " + cluster));
            return cluster;
        }
        return this.getCluster();
    }

    protected Set<String> getColumns(NodeToken token) throws MSROException {
        String envCols = token.getEnv().getAttribute(this.getTableColumnsParamName());
        if (StringUtils.isBlank((String)envCols)) {
            throw new MSROException("cannot find table description");
        }
        log.debug((Object)("using columns from env: " + envCols));
        return Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)envCols));
    }

    protected String asCSV(Iterable<String> columns) {
        return Joiner.on((String)",").skipNulls().join(columns);
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getHbaseTableProperty() {
        return this.hbaseTableProperty;
    }

    public void setHbaseTableProperty(String hbaseTableProperty) {
        this.hbaseTableProperty = hbaseTableProperty;
    }

    public String getTableColumnsParamName() {
        return this.tableColumnsParamName;
    }

    public void setTableColumnsParamName(String tableColumnsParamName) {
        this.tableColumnsParamName = tableColumnsParamName;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public String getTableConfigurationParamName() {
        return this.tableConfigurationParamName;
    }

    public void setTableConfigurationParamName(String tableConfigurationParamName) {
        this.tableConfigurationParamName = tableConfigurationParamName;
    }
}

