/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.hadoop;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class MDStoreDatasourceResolverJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(MDStoreDatasourceResolverJobNode.class);
    private String originalDatasourceIdsCSV;
    @Value(value="${dnet.openaire.dataload.datasource.mdstores.xquery}")
    private String xqueryTemplate;
    @Resource
    private UniqueServiceLocator serviceLocator;

    public String execute(NodeToken token) throws Exception {
        log.info((Object)("resolving MDStore ids for datasources: " + this.getOriginalDatasourceIdsCSV()));
        ArrayList mdIds = Lists.newArrayList();
        for (String originalId : this.splitter().split((CharSequence)this.getOriginalDatasourceIdsCSV())) {
            mdIds.addAll(this.resolveMdIds(originalId));
        }
        log.info((Object)String.format("adding %s mdStore ids in wf env", mdIds.size()));
        token.getEnv().setAttribute("mdId", new Gson().toJson((Object)mdIds));
        return Arc.DEFAULT_ARC;
    }

    public List<String> resolveMdIds(String id) throws ISLookUpException {
        log.info((Object)("Resolving mdID for " + id + ". Cache not used."));
        String xQuery = String.format(this.xqueryTemplate, id);
        List mdIds = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(xQuery);
        return mdIds;
    }

    private Splitter splitter() {
        return Splitter.on((String)",").trimResults().omitEmptyStrings();
    }

    public String getOriginalDatasourceIdsCSV() {
        return this.originalDatasourceIdsCSV;
    }

    public void setOriginalDatasourceIdsCSV(String originalDatasourceIdsCSV) {
        this.originalDatasourceIdsCSV = originalDatasourceIdsCSV;
    }
}

