/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.openaire.directindex.api.DirecIndexApiException;
import eu.dnetlib.openaire.directindex.api.IndexClientMap;
import eu.dnetlib.openaire.directindex.api.IndexDsInfo;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class ResultSubmitterService {
    private static final Log log = LogFactory.getLog(ResultSubmitterService.class);
    @Resource(name="resultSubmitterClientMap")
    private IndexClientMap clientMap;
    @Value(value="${openaire.api.directindex.autocommit.active}")
    private boolean autocommitactive;
    @Value(value="${openaire.api.directindex.autocommit.frequency}")
    private long commitfrquency = 60L;
    private ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public ResultSubmitterService() {
        this.updateCommitSchedule();
    }

    private void updateCommitSchedule() {
        log.info((Object)"updating commit schedule");
        this.executor.scheduleAtFixedRate(() -> {
            if (this.isAutocommitactive()) {
                try {
                    for (Map.Entry<IndexDsInfo, CloudIndexClient> entry : this.clientMap.getClients().entrySet()) {
                        IndexDsInfo i = entry.getKey();
                        CloudIndexClient client = entry.getValue();
                        log.info((Object)("performing commit on " + i.getColl()));
                        try {
                            client.commit();
                        }
                        catch (CloudIndexClientException e) {
                            log.error((Object)("error performing commit on " + i.getColl()), (Throwable)e);
                        }
                    }
                }
                catch (DirecIndexApiException e) {
                    log.error((Object)e);
                }
            }
        }, 0L, this.getCommitfrquency(), TimeUnit.SECONDS);
    }

    public boolean isAutocommitactive() {
        return this.autocommitactive;
    }

    public synchronized void setAutocommitactive(boolean autocommitactive) {
        this.autocommitactive = autocommitactive;
    }

    public long getCommitfrquency() {
        return this.commitfrquency;
    }

    public synchronized void setCommitfrquency(long commitfrquency) {
        this.commitfrquency = commitfrquency;
    }
}

