/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.directindex.api;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.Service;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.openaire.directindex.api.DirecIndexApiException;
import eu.dnetlib.openaire.directindex.api.IndexClientMap;
import eu.dnetlib.openaire.directindex.api.IndexDsInfo;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Value;

public class ResultSubmitterService {
    private static final Log log = LogFactory.getLog(ResultSubmitterService.class);
    @Resource
    private IndexClientMap clientMap;
    @Value(value="${openaire.api.directindex.autocommit.active}")
    private boolean autocommitactive;
    @Value(value="${openaire.api.directindex.autocommit.frequency}")
    private long commitfrquency = 60L;
    private static long COMMIT_FREQUENCY_MINVALUE = 5L;
    private AbstractScheduledService commitService = this.updateCommitSchedule();

    private AbstractScheduledService updateCommitSchedule() {
        log.info((Object)"updating commit schedule");
        if (this.commitService != null && !this.commitService.state().equals((Object)Service.State.TERMINATED)) {
            log.info((Object)"waiting for scheduled commit service to complete ");
            this.commitService.awaitTerminated();
            if (this.commitService.state().equals((Object)Service.State.FAILED)) {
                log.info((Object)this.commitService.failureCause());
            }
            log.info((Object)"stopping commit service");
            this.commitService.stopAsync();
        }
        AbstractScheduledService service = new AbstractScheduledService(){

            protected void runOneIteration() throws CloudIndexClientException, DirecIndexApiException {
                if (ResultSubmitterService.this.isAutocommitactive()) {
                    for (Map.Entry<IndexDsInfo, CloudIndexClient> e : ResultSubmitterService.this.clientMap.getClients().entrySet()) {
                        IndexDsInfo i = e.getKey();
                        CloudIndexClient client = e.getValue();
                        log.info((Object)("performing commit on " + i.getColl()));
                        client.commit();
                    }
                }
            }

            protected AbstractScheduledService.Scheduler scheduler() {
                return AbstractScheduledService.Scheduler.newFixedRateSchedule((long)0L, (long)ResultSubmitterService.this.getCommitfrquency(), (TimeUnit)TimeUnit.SECONDS);
            }
        };
        log.info((Object)String.format("starting commit service, active '%s', frequency '%s'", this.isAutocommitactive(), this.getCommitfrquency()));
        service.startAsync();
        return service;
    }

    public boolean isAutocommitactive() {
        return this.autocommitactive;
    }

    public synchronized void setAutocommitactive(boolean autocommitactive) {
        this.autocommitactive = autocommitactive;
    }

    public long getCommitfrquency() {
        return this.commitfrquency;
    }

    public synchronized void setCommitfrquency(long commitfrquency) {
        if (commitfrquency < COMMIT_FREQUENCY_MINVALUE) {
            throw new RuntimeException("cannot set autocommit frequency: minimum accepted value (inclusive) is " + COMMIT_FREQUENCY_MINVALUE);
        }
        this.commitfrquency = commitfrquency;
        this.updateCommitSchedule();
    }
}

